/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider;

import hudson.Extension;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.CredentialsProvider;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class STSAssumeRoleSessionCredentialsProvider
extends CredentialsProvider {
    private static final int DEFAULT_ROLE_SESSION_DURATION_SECONDS = 900;
    private String roleArn;
    private String roleSessionName;

    @DataBoundConstructor
    public STSAssumeRoleSessionCredentialsProvider(String roleArn, String roleSessionName) {
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    @DataBoundSetter
    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    @DataBoundSetter
    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    @Override
    public AwsCredentialsProvider build() {
        AssumeRoleRequest refreshRequest = this.buildRefreshRequest();
        return StsAssumeRoleCredentialsProvider.builder().refreshRequest(refreshRequest).build();
    }

    private AssumeRoleRequest buildRefreshRequest() {
        return (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName(this.roleSessionName).durationSeconds(Integer.valueOf(900)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        STSAssumeRoleSessionCredentialsProvider that = (STSAssumeRoleSessionCredentialsProvider)o;
        return Objects.equals(this.roleArn, that.roleArn) && Objects.equals(this.roleSessionName, that.roleSessionName);
    }

    public int hashCode() {
        return Objects.hash(this.roleArn, this.roleSessionName);
    }

    @Extension
    @Symbol(value={"assumeRole"})
    public static class DescriptorImpl
    extends CredentialsProvider.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return Messages.assumeRole();
        }
    }
}

