/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.credentials.secretsmanager.config.Filter;
import io.jenkins.plugins.credentials.secretsmanager.config.Value;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import software.amazon.awssdk.services.secretsmanager.model.FilterNameStringType;

@Extension(optional=true, ordinal=2.0)
@Restricted(value={NoExternalUse.class})
public class FilterConfigurator
extends BaseConfigurator<Filter>
implements Configurator<Filter> {
    @NonNull
    public String getName() {
        return "filter";
    }

    public Class<Filter> getTarget() {
        return Filter.class;
    }

    public Filter instance(Mapping mapping, ConfigurationContext context) {
        return new Filter(null, null);
    }

    @NonNull
    public Set<Attribute<Filter, ?>> describe() {
        return Sets.newHashSet((Object[])new Attribute[]{new Attribute("key", String.class).setter((target, key) -> {
            try {
                FilterNameStringType.fromValue((String)key);
                target.setKey((String)key);
            }
            catch (IllegalArgumentException e) {
                throw new ConfiguratorException(e.getLocalizedMessage());
            }
        }), new MultivaluedAttribute("values", String.class).setter((target, values) -> {
            List<Value> mappedValues = values.stream().map(Value::new).collect(Collectors.toList());
            target.setValues(mappedValues);
        })});
    }

    @CheckForNull
    public CNode describe(Filter instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute<Filter, ?> attribute : this.describe()) {
            mapping.put((Object)attribute.getName(), (Object)attribute.describe((Object)instance, context));
        }
        return mapping;
    }
}

