/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.factory.username_password;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.AwsCredentialsProvider;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class AwsUsernamePasswordCredentials
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    private final Supplier<Secret> password;
    private final String username;

    public AwsUsernamePasswordCredentials(String id, String description, Supplier<Secret> password, String username) {
        super(id, description);
        this.password = password;
        this.username = username;
    }

    @NonNull
    public Secret getPassword() {
        return this.password.get();
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.usernamePassword();
        }

        public String getIconClassName() {
            return "symbol-id-card";
        }

        public boolean isApplicable(CredentialsProvider provider) {
            return provider instanceof AwsCredentialsProvider;
        }
    }
}

