/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.credentials.secretsmanager.FolderScope;
import java.util.Objects;

public class ScopedCredentials
implements StandardCredentials {
    private final StandardCredentials delegate;
    private final FolderScope folderScope;

    public ScopedCredentials(@NonNull StandardCredentials delegate, @NonNull FolderScope folderScope) {
        this.delegate = delegate;
        this.folderScope = folderScope;
    }

    @NonNull
    public FolderScope getFolderScope() {
        return this.folderScope;
    }

    @CheckForNull
    public <T> T as(@NonNull Class<T> type) {
        if (type.isInstance(this.delegate)) {
            return type.cast(this.delegate);
        }
        return null;
    }

    @NonNull
    public StandardCredentials getDelegate() {
        return this.delegate;
    }

    @NonNull
    public String getId() {
        return this.delegate.getId();
    }

    @NonNull
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @NonNull
    public CredentialsScope getScope() {
        return Objects.requireNonNullElse(this.delegate.getScope(), CredentialsScope.GLOBAL);
    }

    @NonNull
    public CredentialsDescriptor getDescriptor() {
        return this.delegate.getDescriptor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopedCredentials that = (ScopedCredentials)o;
        if (!this.delegate.equals((Object)that.delegate)) {
            return false;
        }
        return this.folderScope.equals(that.folderScope);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + this.folderScope.hashCode();
        return result;
    }

    public String toString() {
        return "ScopedCredentials{id=" + this.getId() + ", folderScope=" + String.valueOf(this.folderScope) + ", delegate=" + this.delegate.getClass().getSimpleName() + "}";
    }
}

