/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Item;
import hudson.model.ItemGroup;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class ItemGroups {
    private static final Logger LOG = Logger.getLogger(ItemGroups.class.getName());

    private ItemGroups() {
    }

    @CheckForNull
    public static String getFolderPath(@CheckForNull ItemGroup<?> itemGroup) {
        Item item;
        String fullName;
        if (itemGroup == null) {
            LOG.log(Level.FINE, "ItemGroup is null, treating as global context");
            return null;
        }
        if (itemGroup instanceof Jenkins) {
            LOG.log(Level.FINE, "ItemGroup is Jenkins root, treating as global context");
            return null;
        }
        if (itemGroup instanceof Item && (fullName = (item = (Item)itemGroup).getFullName()) != null && !fullName.isEmpty()) {
            String normalized = ItemGroups.normalizePath(fullName);
            LOG.log(Level.FINE, "Extracted folder path from Item: {0}", normalized);
            return normalized;
        }
        LOG.log(Level.FINE, "Could not extract folder path from ItemGroup {0}, treating as global context", itemGroup.getClass().getSimpleName());
        return null;
    }

    @CheckForNull
    private static String normalizePath(@CheckForNull String path) {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        String normalized = path.trim();
        while (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        while (normalized.endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized.isEmpty() ? null : normalized;
    }
}

