/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FolderScope
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(FolderScope.class.getName());
    private static final FolderScope GLOBAL = new FolderScope(Collections.emptySet());
    private final Set<String> folderPaths;

    private FolderScope(@NonNull Set<String> folderPaths) {
        this.folderPaths = Collections.unmodifiableSet(folderPaths);
    }

    @NonNull
    public static FolderScope global() {
        return GLOBAL;
    }

    @NonNull
    public static FolderScope of(String ... paths) {
        if (paths.length == 0) {
            return FolderScope.global();
        }
        Set<String> normalizedPaths = Arrays.stream(paths).filter(Objects::nonNull).map(FolderScope::normalizePath).filter(path -> !path.isEmpty()).collect(Collectors.toSet());
        return normalizedPaths.isEmpty() ? FolderScope.global() : new FolderScope(normalizedPaths);
    }

    @NonNull
    public static FolderScope parse(@CheckForNull String commaSeparated) {
        if (commaSeparated == null || commaSeparated.trim().isEmpty()) {
            LOG.log(Level.FINE, "Empty or null folder scope, treating as global");
            return FolderScope.global();
        }
        String[] paths = commaSeparated.split(",");
        Set<String> normalizedPaths = Arrays.stream(paths).map(String::trim).filter(path -> !path.isEmpty()).map(FolderScope::normalizePath).filter(path -> !path.isEmpty()).collect(Collectors.toSet());
        if (normalizedPaths.isEmpty()) {
            LOG.log(Level.WARNING, "Could not parse any valid folder paths from: {0}", commaSeparated);
            return FolderScope.global();
        }
        LOG.log(Level.FINE, "Parsed folder scope: {0}", normalizedPaths);
        return new FolderScope(normalizedPaths);
    }

    public boolean isGlobal() {
        return this.folderPaths.isEmpty();
    }

    public boolean isAccessibleFrom(@CheckForNull String requestingFolderPath) {
        if (this.isGlobal()) {
            LOG.log(Level.FINER, "Global scope, accessible from anywhere");
            return true;
        }
        if (requestingFolderPath == null || requestingFolderPath.trim().isEmpty()) {
            LOG.log(Level.FINER, "Requesting from global context, folder-scoped credential not accessible");
            return false;
        }
        String normalizedRequestingPath = FolderScope.normalizePath(requestingFolderPath);
        if (normalizedRequestingPath.isEmpty()) {
            LOG.log(Level.FINER, "Normalized requesting path is empty, treating as global context");
            return false;
        }
        boolean accessible = this.folderPaths.stream().anyMatch(allowedPath -> FolderScope.isChildOf(normalizedRequestingPath, allowedPath));
        LOG.log(Level.FINER, "Folder scope check: requesting={0}, allowed={1}, accessible={2}", new Object[]{normalizedRequestingPath, this.folderPaths, accessible});
        return accessible;
    }

    private static boolean isChildOf(@NonNull String childPath, @NonNull String parentPath) {
        if (childPath.equals(parentPath)) {
            return true;
        }
        return childPath.startsWith(parentPath + "/");
    }

    @NonNull
    private static String normalizePath(@CheckForNull String path) {
        if (path == null || path.trim().isEmpty()) {
            return "";
        }
        String normalized = path.trim();
        while (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        while (normalized.endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        normalized = normalized.replaceAll("/+", "/");
        return normalized;
    }

    @NonNull
    public Set<String> getFolderPaths() {
        return this.folderPaths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FolderScope that = (FolderScope)o;
        return Objects.equals(this.folderPaths, that.folderPaths);
    }

    public int hashCode() {
        return Objects.hash(this.folderPaths);
    }

    public String toString() {
        return this.isGlobal() ? "FolderScope{GLOBAL}" : "FolderScope{" + String.valueOf(this.folderPaths) + "}";
    }
}

