/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import io.jenkins.plugins.credentials.secretsmanager.AwsCredentialsStore;
import io.jenkins.plugins.credentials.secretsmanager.CustomSuppliers;
import io.jenkins.plugins.credentials.secretsmanager.ItemGroups;
import io.jenkins.plugins.credentials.secretsmanager.ScopedCredentials;
import io.jenkins.plugins.credentials.secretsmanager.config.PluginConfiguration;
import io.jenkins.plugins.credentials.secretsmanager.supplier.CredentialsSupplier;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

@Extension
public class AwsCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOG = Logger.getLogger(AwsCredentialsProvider.class.getName());
    private final Map<ModelObject, AwsCredentialsStore> stores = new ConcurrentHashMap<ModelObject, AwsCredentialsStore>();
    private final Supplier<Collection<StandardCredentials>> credentialsSupplier = AwsCredentialsProvider.memoizeWithExpiration(CredentialsSupplier.standard(), () -> PluginConfiguration.normalize(PluginConfiguration.getInstance().getCache()));

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@Nonnull Class<C> type, ItemGroup itemGroup, Authentication authentication) {
        if (ACL.SYSTEM.equals((Object)authentication)) {
            Collection<Object> allCredentials = Collections.emptyList();
            try {
                allCredentials = this.credentialsSupplier.get();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not list credentials in Secrets Manager: message=[{0}]", e.getMessage());
            }
            String requestingFolderPath = ItemGroups.getFolderPath(itemGroup);
            LOG.log(Level.FINE, "Filtering credentials for folder path: {0}", requestingFolderPath != null ? requestingFolderPath : "<global>");
            return allCredentials.stream().filter(cred -> {
                if (cred instanceof ScopedCredentials) {
                    ScopedCredentials scoped = (ScopedCredentials)cred;
                    boolean accessible = scoped.getFolderScope().isAccessibleFrom(requestingFolderPath);
                    if (!accessible) {
                        LOG.log(Level.FINER, "Credential {0} not accessible from folder {1}", new Object[]{scoped.getId(), requestingFolderPath});
                    }
                    return accessible;
                }
                return true;
            }).map(cred -> {
                if (cred instanceof ScopedCredentials) {
                    StandardCredentials delegate = ((ScopedCredentials)cred).getDelegate();
                    return delegate;
                }
                return cred;
            }).filter(c -> type.isAssignableFrom(c.getClass())).map(type::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public CredentialsStore getStore(ModelObject object) {
        if (object == Jenkins.get() || object instanceof ItemGroup && object instanceof Item) {
            return this.stores.computeIfAbsent(object, ctx -> new AwsCredentialsStore(this, (ModelObject)ctx));
        }
        return null;
    }

    public String getIconClassName() {
        return "icon-aws-secrets-manager-credentials-store";
    }

    private static <T> Supplier<T> memoizeWithExpiration(Supplier<T> base, Supplier<Duration> duration) {
        return CustomSuppliers.memoizeWithExpiration(base, duration);
    }
}

