/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.factory.certificate;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsUnavailableException;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.AwsCredentialsProvider;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class AwsCertificateCredentials
extends BaseStandardCredentials
implements StandardCertificateCredentials {
    private final Supplier<SecretBytes> keyStore;
    private static final char[] NO_PASSWORD = new char[0];
    private static final Secret NO_SECRET = Secret.fromString((String)"");

    public AwsCertificateCredentials(String id, String description, Supplier<SecretBytes> keyStore) {
        super(id, description);
        this.keyStore = keyStore;
    }

    @NonNull
    public KeyStore getKeyStore() {
        KeyStore keyStore;
        SecretBytes secretBytes = this.keyStore.get();
        ByteArrayInputStream stream = new ByteArrayInputStream(secretBytes.getPlainData());
        try {
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(stream, NO_PASSWORD);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new CredentialsUnavailableException("keyStore", Messages.noCertificateError());
            }
        }
        ((InputStream)stream).close();
        return keyStore;
    }

    @NonNull
    public Secret getPassword() {
        return NO_SECRET;
    }

    SecretBytes getSecretBytes() {
        return this.keyStore.get();
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.certificate();
        }

        public String getIconClassName() {
            return "icon-application-certificate";
        }

        public boolean isApplicable(CredentialsProvider provider) {
            return provider instanceof AwsCredentialsProvider;
        }
    }
}

