/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config;

import com.amazonaws.services.secretsmanager.model.FilterNameStringType;
import hudson.Extension;
import io.jenkins.plugins.credentials.secretsmanager.config.Client;
import io.jenkins.plugins.credentials.secretsmanager.config.EndpointConfiguration;
import io.jenkins.plugins.credentials.secretsmanager.config.Filter;
import io.jenkins.plugins.credentials.secretsmanager.config.Filters;
import io.jenkins.plugins.credentials.secretsmanager.config.ListSecrets;
import io.jenkins.plugins.credentials.secretsmanager.config.Tag;
import io.jenkins.plugins.credentials.secretsmanager.config.Transformations;
import io.jenkins.plugins.credentials.secretsmanager.config.Value;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"awsCredentialsProvider"})
public class PluginConfiguration
extends GlobalConfiguration {
    private static final Logger LOG = Logger.getLogger(PluginConfiguration.class.getName());
    private static final Duration NO_CACHE = Duration.ofNanos(1L);
    private static final Duration DEFAULT_CACHE = Duration.ofSeconds(300L);
    private Boolean cache;
    private Client client;
    @Deprecated
    private transient EndpointConfiguration endpointConfiguration;
    @Deprecated
    private transient Filters filters;
    private ListSecrets listSecrets;
    private Transformations transformations;

    public PluginConfiguration() {
        this.load();
    }

    public static PluginConfiguration getInstance() {
        return (PluginConfiguration)((Object)PluginConfiguration.all().get(PluginConfiguration.class));
    }

    public static Duration normalize(Boolean cache) {
        if (cache == null || cache.booleanValue()) {
            LOG.config("CredentialsProvider cache enabled");
            return DEFAULT_CACHE;
        }
        LOG.config("CredentialsProvider cache disabled");
        return NO_CACHE;
    }

    protected Object readResolve() {
        if (this.endpointConfiguration != null) {
            this.client = new Client(null, null, this.endpointConfiguration, null);
            this.endpointConfiguration = null;
        }
        if (this.filters != null && this.filters.getTag() != null) {
            Tag tag = this.filters.getTag();
            Filter tagKey = new Filter(FilterNameStringType.TagKey.toString(), Collections.singletonList(new Value(tag.getKey())));
            Filter tagValue = new Filter(FilterNameStringType.TagValue.toString(), Collections.singletonList(new Value(tag.getValue())));
            List<Filter> filters = Arrays.asList(tagKey, tagValue);
            this.listSecrets = new ListSecrets(filters);
        }
        return this;
    }

    public Boolean getCache() {
        return this.cache;
    }

    @DataBoundSetter
    public void setCache(Boolean cache) {
        this.cache = cache;
        this.save();
    }

    public Client getClient() {
        return this.client;
    }

    @DataBoundSetter
    public void setClient(Client client) {
        this.client = client;
        this.save();
    }

    public ListSecrets getListSecrets() {
        return this.listSecrets;
    }

    @DataBoundSetter
    public void setListSecrets(ListSecrets listSecrets) {
        this.listSecrets = listSecrets;
        this.save();
    }

    public Transformations getTransformations() {
        return this.transformations;
    }

    @DataBoundSetter
    public void setTransformations(Transformations transformations) {
        this.transformations = transformations;
        this.save();
    }

    public synchronized boolean configure(StaplerRequest req, JSONObject json) {
        this.client = null;
        this.listSecrets = null;
        this.transformations = null;
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }
}

