/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.aws.global_configuration;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.util.FormApply;
import io.jenkins.plugins.aws.global_configuration.AwsGlobalConfigurationCategory;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"aws"})
public class AwsManagementLink
extends ManagementLink
implements Describable<AwsManagementLink> {
    private static Logger LOGGER = Logger.getLogger(AwsManagementLink.class.getName());
    public static final Predicate<GlobalConfigurationCategory> FILTER = new Predicate<GlobalConfigurationCategory>(){

        public boolean apply(GlobalConfigurationCategory input) {
            return input instanceof AwsGlobalConfigurationCategory;
        }
    };

    @CheckForNull
    public String getUrlName() {
        return "aws";
    }

    @CheckForNull
    public String getDisplayName() {
        return "AWS";
    }

    public String getIconFileName() {
        return "symbol-aws-icon-solid plugin-oss-symbols-api";
    }

    public String getDescription() {
        return "Amazon Web Services Configuration";
    }

    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public Descriptor<AwsManagementLink> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(AwsManagementLink.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public synchronized void doConfigure(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        BulkChange bc = new BulkChange((Saveable)Jenkins.get());
        try {
            boolean result = this.configure(req, req.getSubmittedForm());
            LOGGER.log(Level.FINE, "security saved: " + result);
            Jenkins.get().save();
            FormApply.success((String)(req.getContextPath() + "/manage")).generateResponse(req, rsp, null);
        }
        finally {
            bc.commit();
        }
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        boolean result = true;
        for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfigByDescriptor(descriptor -> FILTER.apply((Object)descriptor.getCategory()))) {
            result &= this.configureDescriptor(req, json, d);
        }
        return result;
    }

    private boolean configureDescriptor(StaplerRequest2 req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }

    @Extension
    @Symbol(value={"aws"})
    public static final class DescriptorImpl
    extends Descriptor<AwsManagementLink> {
        public String getDisplayName() {
            return "AWS";
        }
    }
}

