/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.aws.global_configuration;

import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.aws.global_configuration.AbstractAwsGlobalConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;

@Symbol(value={"awsCredentials"})
@Extension
public final class CredentialsAwsGlobalConfiguration
extends AbstractAwsGlobalConfiguration {
    private static int SESSION_DURATION = Integer.getInteger(CredentialsAwsGlobalConfiguration.class.getName() + ".sessionDuration", 3600);
    private String region;
    private String credentialsId;

    public CredentialsAwsGlobalConfiguration() {
        this.load();
    }

    @Restricted(value={NoExternalUse.class})
    protected CredentialsAwsGlobalConfiguration(boolean test) {
    }

    public String getRegion() {
        return this.region;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = Util.fixEmpty((String)region);
        this.checkValue(this.doCheckRegion(region));
        this.save();
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = StringUtils.defaultIfBlank((String)credentialsId, null);
        this.save();
    }

    @CheckForNull
    public AmazonWebServicesCredentials getCredentials() {
        return this.credentialsId != null ? this.getCredentials(this.credentialsId) : null;
    }

    @CheckForNull
    public AmazonWebServicesCredentials getCredentials(@NonNull String credentialsId) {
        Optional<AmazonWebServicesCredentials> credential = CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().filter(it -> it.getId().equals(credentialsId)).findFirst();
        if (credential.isPresent()) {
            return credential.get();
        }
        return null;
    }

    private AwsSessionCredentials sessionCredentialsFromKeyAndSecret(String region, @NonNull AmazonWebServicesCredentials jenkinsAwsCredentials) {
        AwsCredentials awsCredentials = jenkinsAwsCredentials.resolveCredentials();
        if (awsCredentials instanceof AwsSessionCredentials) {
            return (AwsSessionCredentials)awsCredentials;
        }
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        Credentials credentials = this.getSessionCredentials((AwsCredentialsProvider)credentialsProvider, region);
        return AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken());
    }

    private Credentials getSessionCredentials(AwsCredentialsProvider credentialsProvider, String region) {
        StsClientBuilder stsClientBuilder = (StsClientBuilder)StsClient.builder().credentialsProvider(credentialsProvider);
        if (region != null) {
            stsClientBuilder.region(Region.of((String)region));
        }
        StsClient stsClient = (StsClient)stsClientBuilder.build();
        GetSessionTokenRequest sessionTokenRequest = (GetSessionTokenRequest)GetSessionTokenRequest.builder().durationSeconds(Integer.valueOf(this.getSessionDuration())).build();
        GetSessionTokenResponse sessionToken = stsClient.getSessionToken(sessionTokenRequest);
        return sessionToken.credentials();
    }

    private AwsSessionCredentials sessionCredentialsFromInstanceProfile() throws IOException {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        AwsCredentials awsCredentials = credentialsProvider.resolveCredentials();
        if (!(awsCredentials instanceof AwsSessionCredentials)) {
            throw new IOException("No valid session credentials");
        }
        return (AwsSessionCredentials)awsCredentials;
    }

    @Deprecated
    public AWSSessionCredentials sessionCredentials(@NonNull AwsClientBuilder<?, ?> builder) throws IOException {
        return CredentialsAwsGlobalConfiguration.fromAwsSessionCredentials(this.sessionCredentials(this.getRegion(), this.getCredentialsId()));
    }

    public AwsSessionCredentials sessionCredentials(String region, String credentialsId) throws IOException {
        AmazonWebServicesCredentials baseCredentials;
        AmazonWebServicesCredentials amazonWebServicesCredentials = baseCredentials = StringUtils.isNotBlank((String)credentialsId) ? this.getCredentials(credentialsId) : null;
        if (baseCredentials != null) {
            return this.sessionCredentialsFromKeyAndSecret(region, baseCredentials);
        }
        return this.sessionCredentialsFromInstanceProfile();
    }

    @Deprecated
    public AWSSessionCredentials sessionCredentials(@NonNull AwsClientBuilder<?, ?> builder, String region, String credentialsId) throws IOException {
        return CredentialsAwsGlobalConfiguration.fromAwsSessionCredentials(this.sessionCredentials(region, credentialsId));
    }

    private static AWSSessionCredentials fromAwsSessionCredentials(AwsSessionCredentials awsSessionCredentials) {
        Objects.requireNonNull(awsSessionCredentials);
        return new BasicSessionCredentials(awsSessionCredentials.accessKeyId(), awsSessionCredentials.secretAccessKey(), awsSessionCredentials.sessionToken(), (String)awsSessionCredentials.accountId().orElse(null), (String)awsSessionCredentials.providerName().orElse(null));
    }

    private void checkValue(@NonNull FormValidation formValidation) {
        if (formValidation.kind == FormValidation.Kind.ERROR) {
            throw new Failure(formValidation.getMessage());
        }
    }

    public int getSessionDuration() {
        return SESSION_DURATION;
    }

    @NonNull
    public String getDisplayName() {
        return "Amazon S3 Bucket Access settings";
    }

    @NonNull
    public static CredentialsAwsGlobalConfiguration get() {
        return (CredentialsAwsGlobalConfiguration)((Object)ExtensionList.lookupSingleton(CredentialsAwsGlobalConfiguration.class));
    }

    public ListBoxModel doFillRegionItems() {
        ListBoxModel regions = new ListBoxModel();
        regions.add("Auto", "");
        for (Region s : Region.regions()) {
            RegionMetadata regionMetadata = RegionMetadata.of((Region)s);
            regions.add(regionMetadata != null ? regionMetadata.description() : s.id(), s.id());
        }
        return regions;
    }

    @RequirePOST
    public ListBoxModel doFillCredentialsIdItems() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ListBoxModel credentials = new ListBoxModel();
        credentials.add("IAM instance Profile/user AWS configuration", "");
        credentials.addAll((Collection)CredentialsProvider.listCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(AmazonWebServicesCredentials.class)));
        return credentials;
    }

    public FormValidation doCheckRegion(@QueryParameter String region) {
        if (StringUtils.isNotBlank((String)region) && Region.regions().stream().noneMatch(r -> r.id().equals(region))) {
            return FormValidation.error((String)"Region is not valid");
        }
        return FormValidation.ok();
    }
}

