/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import io.jenkins.plugins.audit.event.Login;
import io.jenkins.plugins.audit.event.Logout;
import io.jenkins.plugins.audit.helpers.DateTimeHelper;
import jenkins.security.SecurityListener;
import org.apache.logging.log4j.audit.LogEventFactory;

@Extension
public class UserLogListener
extends SecurityListener {
    protected void loggedIn(@NonNull String username) {
        Login login = (Login)LogEventFactory.getEvent(Login.class);
        login.setUserId(username);
        login.setTimestamp(DateTimeHelper.currentDateTimeISO());
        login.logEvent();
    }

    protected void loggedOut(@NonNull String username) {
        Logout logout = (Logout)LogEventFactory.getEvent(Logout.class);
        logout.setUserId(username);
        logout.setTimestamp(DateTimeHelper.currentDateTimeISO());
        logout.logEvent();
    }

    public static ExtensionList<UserLogListener> getInstance() {
        return ExtensionList.lookup(UserLogListener.class);
    }
}

