/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import io.jenkins.plugins.audit.event.CreateUser;
import io.jenkins.plugins.audit.helpers.DateTimeHelper;
import jenkins.security.SecurityListener;
import org.apache.logging.log4j.audit.LogEventFactory;

@Extension
public class UserCreationListener
extends SecurityListener {
    protected void userCreated(@NonNull String username) {
        CreateUser user = (CreateUser)LogEventFactory.getEvent(CreateUser.class);
        user.setUserId(username);
        user.setTimestamp(DateTimeHelper.currentDateTimeISO());
        user.logEvent();
    }

    public static ExtensionList<UserCreationListener> getInstance() {
        return ExtensionList.lookup(UserCreationListener.class);
    }
}

