/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.listeners;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Fingerprint;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import io.jenkins.plugins.audit.event.UseCredentials;
import io.jenkins.plugins.audit.helpers.DateTimeHelper;
import java.util.Hashtable;
import org.apache.logging.log4j.audit.LogEventFactory;

@Extension
public class SaveableChangeListener
extends SaveableListener {
    public void onChange(Saveable o, XmlFile file) {
        if (o instanceof Fingerprint) {
            UseCredentials useCredentials = (UseCredentials)LogEventFactory.getEvent(UseCredentials.class);
            Fingerprint fp = (Fingerprint)o;
            useCredentials.setFileName(fp.getFileName());
            useCredentials.setName(fp.getDisplayName());
            useCredentials.setTimestamp(DateTimeHelper.formatDateISO(fp.getTimestamp().getTime()));
            Hashtable usages = fp.getUsages();
            if (usages != null) {
                usages.values().forEach(value -> {
                    useCredentials.setUsage(value.toString());
                    useCredentials.logEvent();
                });
            }
        }
    }
}

