/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Node;
import hudson.model.User;
import io.jenkins.plugins.audit.event.CreateNode;
import io.jenkins.plugins.audit.event.DeleteNode;
import io.jenkins.plugins.audit.event.UpdateNode;
import io.jenkins.plugins.audit.helpers.DateTimeHelper;
import jenkins.model.NodeListener;
import org.apache.logging.log4j.audit.LogEventFactory;

@Extension
public class NodeChangeListener
extends NodeListener {
    protected void onCreated(@NonNull Node node) {
        CreateNode nodeCreateEvent = (CreateNode)LogEventFactory.getEvent(CreateNode.class);
        nodeCreateEvent.setNodeName(node.getNodeName());
        nodeCreateEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            nodeCreateEvent.setUserId(user.getId());
        }
        nodeCreateEvent.logEvent();
    }

    protected void onUpdated(@NonNull Node oldOne, @NonNull Node newOne) {
        UpdateNode nodeUpdateEvent = (UpdateNode)LogEventFactory.getEvent(UpdateNode.class);
        nodeUpdateEvent.setNodeName(newOne.getNodeName());
        nodeUpdateEvent.setOldNodeName(oldOne.getNodeName());
        nodeUpdateEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            nodeUpdateEvent.setUserId(user.getId());
        }
        nodeUpdateEvent.logEvent();
    }

    protected void onDeleted(@NonNull Node node) {
        DeleteNode nodeDeleteEvent = (DeleteNode)LogEventFactory.getEvent(DeleteNode.class);
        nodeDeleteEvent.setNodeName(node.getNodeName());
        nodeDeleteEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            nodeDeleteEvent.setUserId(user.getId());
        }
        nodeDeleteEvent.logEvent();
    }

    public static ExtensionList<NodeChangeListener> getInstance() {
        return ExtensionList.lookup(NodeChangeListener.class);
    }
}

