/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.listeners.ItemListener;
import io.jenkins.plugins.audit.event.CopyItem;
import io.jenkins.plugins.audit.event.CreateItem;
import io.jenkins.plugins.audit.event.DeleteItem;
import io.jenkins.plugins.audit.event.UpdateItem;
import io.jenkins.plugins.audit.helpers.DateTimeHelper;
import org.apache.logging.log4j.audit.LogEventFactory;

@Extension
public class ItemChangeListener
extends ItemListener {
    public void onCreated(@NonNull Item item) {
        CreateItem itemCreateEvent = (CreateItem)LogEventFactory.getEvent(CreateItem.class);
        itemCreateEvent.setItemName(item.getName());
        itemCreateEvent.setItemUri(item.getUrl());
        itemCreateEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            itemCreateEvent.setUserId(user.getId());
        }
        itemCreateEvent.logEvent();
    }

    public void onCopied(Item src, Item item) {
        CopyItem itemCopyEvent = (CopyItem)LogEventFactory.getEvent(CopyItem.class);
        itemCopyEvent.setItemName(item.getName());
        itemCopyEvent.setItemUri(item.getUrl());
        itemCopyEvent.setSourceItemUri(src.getUrl());
        itemCopyEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            itemCopyEvent.setUserId(user.getId());
        }
        itemCopyEvent.logEvent();
    }

    public void onDeleted(Item item) {
        DeleteItem itemDeleteEvent = (DeleteItem)LogEventFactory.getEvent(DeleteItem.class);
        itemDeleteEvent.setItemName(item.getName());
        itemDeleteEvent.setItemUri(item.getUrl());
        itemDeleteEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            itemDeleteEvent.setUserId(user.getId());
        }
        itemDeleteEvent.logEvent();
    }

    public void onUpdated(Item item) {
        UpdateItem itemUpdateEvent = (UpdateItem)LogEventFactory.getEvent(UpdateItem.class);
        itemUpdateEvent.setItemName(item.getName());
        itemUpdateEvent.setItemUri(item.getUrl());
        itemUpdateEvent.setTimestamp(DateTimeHelper.currentDateTimeISO());
        User user = User.current();
        if (user != null) {
            itemUpdateEvent.setUserId(user.getId());
        }
        itemUpdateEvent.logEvent();
    }

    public static ExtensionList<ItemChangeListener> getInstance() {
        return ExtensionList.lookup(ItemChangeListener.class);
    }
}

