/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.audit.event.BuildFinish;
import io.jenkins.plugins.audit.event.BuildStart;
import io.jenkins.plugins.audit.helpers.DateTimeHelper;
import java.util.stream.Collectors;
import org.apache.logging.log4j.audit.LogEventFactory;

@Extension
public class BuildListener
extends RunListener<Run<?, ?>> {
    public void onStarted(Run<?, ?> run, TaskListener listener) {
        BuildStart buildStart = (BuildStart)LogEventFactory.getEvent(BuildStart.class);
        buildStart.setBuildNumber(run.getNumber());
        buildStart.setCause(run.getCauses().stream().map(Cause::getShortDescription).collect(Collectors.toList()));
        buildStart.setProjectName(run.getParent().getFullName());
        buildStart.setTimestamp(DateTimeHelper.formatDateISO(run.getStartTimeInMillis()));
        buildStart.logEvent();
    }

    public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
        BuildFinish buildFinish = (BuildFinish)LogEventFactory.getEvent(BuildFinish.class);
        buildFinish.setTimestamp(DateTimeHelper.currentDateTimeISO());
        buildFinish.setBuildNumber(run.getNumber());
        buildFinish.setCause(run.getCauses().stream().map(Cause::getShortDescription).collect(Collectors.toList()));
        buildFinish.setProjectName(run.getParent().getFullName());
        buildFinish.logEvent();
    }

    public static ExtensionList<BuildListener> getInstance() {
        return ExtensionList.lookup(BuildListener.class);
    }
}

