/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.helpers;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DateTimeHelper {
    public static String formatDateISO(long milliseconds) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), ZoneId.systemDefault()));
    }

    public static String currentDateTimeISO() {
        return DateTimeHelper.formatDateISO(System.currentTimeMillis());
    }
}

