/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.filter;

import hudson.Extension;
import hudson.init.Initializer;
import hudson.model.User;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.ThreadContext;

@Extension
public class RequestContextFilter
implements Filter {
    @Initializer
    public static void init() throws ServletException {
        PluginServletFilter.addFilter((Filter)new RequestContextFilter());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        User user = User.current();
        ThreadContext.put((String)"userId", (String)(user != null ? user.getId() : "SYSTEM"));
        ThreadContext.putIfNull((String)"requestId", (String)UUID.randomUUID().toString());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            ThreadContext.put((String)"requestMethod", (String)httpRequest.getMethod());
            ThreadContext.put((String)"requestUri", (String)httpRequest.getRequestURI());
        }
        chain.doFilter(request, response);
        ThreadContext.clearMap();
    }
}

