/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.ListBoxModel;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class AuditLogConfiguration
extends GlobalConfiguration {
    private String logDestination;
    private String appenderType;
    private String syslogHost;
    private int syslogPort;
    private String syslogProto;
    private int enterpriseNumber;

    public static AuditLogConfiguration getInstance() {
        return (AuditLogConfiguration)((Object)ExtensionList.lookupSingleton(AuditLogConfiguration.class));
    }

    public AuditLogConfiguration() {
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public String getAppenderType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.appenderType, (CharSequence)"jsonLayout");
    }

    @DataBoundSetter
    public void setAppenderType(String appenderType) {
        this.appenderType = appenderType;
        this.save();
        this.reloadLogger();
    }

    public String getLogDestination() {
        String defaultStr = Jenkins.get().getRootDir().toPath().resolve("logs").resolve("audit").resolve("audit.log").toString();
        return (String)StringUtils.defaultIfBlank((CharSequence)this.logDestination, (CharSequence)defaultStr);
    }

    @DataBoundSetter
    public void setLogDestination(String logDestination) {
        this.logDestination = logDestination;
        this.save();
        this.reloadLogger();
    }

    public String getSyslogHost() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.syslogHost, (CharSequence)"localhost");
    }

    @DataBoundSetter
    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
        this.save();
        this.reloadLogger();
    }

    public int getSyslogPort() {
        return this.syslogPort > 0 ? this.syslogPort : 1854;
    }

    @DataBoundSetter
    public void setSyslogPort(int syslogPort) {
        this.syslogPort = syslogPort;
        this.save();
        this.reloadLogger();
    }

    public String getSyslogProto() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.syslogProto, (CharSequence)"TCP");
    }

    @DataBoundSetter
    public void setSyslogProto(String syslogProto) {
        this.syslogProto = syslogProto;
        this.save();
        this.reloadLogger();
    }

    public int getEnterpriseNumber() {
        return this.enterpriseNumber > 0 ? this.enterpriseNumber : 18060;
    }

    @DataBoundSetter
    public void setEnterpriseNumber(int enterpriseNumber) {
        this.enterpriseNumber = enterpriseNumber;
        this.save();
        this.reloadLogger();
    }

    private void reloadLogger() {
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        if (loggerContext instanceof LoggerContext) {
            ((LoggerContext)loggerContext).reconfigure();
        }
    }

    public ListBoxModel doFillAppenderTypeItems() {
        ListBoxModel items = new ListBoxModel();
        items.add("jsonLayout");
        items.add("syslogLayout");
        return items;
    }
}

