/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.audit.config;

import io.jenkins.plugins.audit.config.AuditLogConfiguration;
import java.net.URI;
import java.nio.file.Path;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(name="AuditConfigurationFactory", category="ConfigurationFactory")
@Order(value=50)
public class AuditConfigurationFactory
extends ConfigurationFactory {
    private static Configuration createConfiguration(String name, ConfigurationBuilder<BuiltConfiguration> builder) {
        AuditLogConfiguration auditLogConfiguration = AuditLogConfiguration.getInstance();
        builder.setConfigurationName(name).setStatusLevel(Level.ERROR).setPackages("io.jenkins.plugins.audit.plugins").setConfigurationName("JenkinsAuditLog");
        Path logs = Jenkins.get().getRootDir().toPath().resolve("logs").resolve("audit");
        builder.add((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("html", "RollingRandomAccessFile").addAttribute("fileName", (Object)logs.resolve("html").resolve("audit.html"))).addAttribute("filePattern", (Object)logs.resolve("html").resolve("audit-%d{yyyy-MM-dd}.html"))).add((LayoutComponentBuilder)((LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("CustomHTMLLayout").addAttribute("title", "Audit Log")).addAttribute("charset", "UTF-8")).addAttribute("locationInfo", false)).addComponent(builder.newComponent("TimeBasedTriggeringPolicy"))).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "50 MB"))).addComponent(builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 30)));
        builder.add(builder.newRootLogger(Level.OFF));
        LoggerComponentBuilder auditLogger = (LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("AuditLogger", Level.ALL).addAttribute("additivity", false)).add(builder.newAppenderRef("html"));
        String appenderType = auditLogConfiguration.getAppenderType();
        if (appenderType.equals("jsonLayout")) {
            String auditLogDestination = auditLogConfiguration.getLogDestination();
            builder.add((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("audit", "RollingRandomAccessFile").addAttribute("fileName", auditLogDestination)).addAttribute("filePattern", auditLogDestination + ".%d{yyyyMMdd_HHmmss}-%i.log.gz")).add((LayoutComponentBuilder)builder.newLayout("JsonLayout").addAttribute("properties", true)).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "50 MB"))).addComponent(builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 30)));
            auditLogger.add(builder.newAppenderRef("audit"));
        } else if (appenderType.equals("syslogLayout")) {
            builder.add((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("audit", "Syslog").addAttribute("format", "RFC5424")).addAttribute("host", auditLogConfiguration.getSyslogHost())).addAttribute("port", auditLogConfiguration.getSyslogPort())).addAttribute("protocol", auditLogConfiguration.getSyslogProto())).addAttribute("appName", "ALP")).addAttribute("mdcId", "mdc")).addAttribute("includeMDC", true)).addAttribute("facility", "LOCAL0")).addAttribute("enterpriseNumber", auditLogConfiguration.getEnterpriseNumber())).addAttribute("newLine", true)).addAttribute("messageId", "Server")).addAttribute("id", "App"));
            auditLogger.add(builder.newAppenderRef("audit"));
        }
        return (Configuration)builder.add(auditLogger).build();
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        return AuditConfigurationFactory.createConfiguration(name, (ConfigurationBuilder<BuiltConfiguration>)ConfigurationBuilderFactory.newConfigurationBuilder());
    }
}

