package io.jenkins.plugins.audit.event;

import java.util.List;
import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.Required;

/**
 * Usage of Credentials
 * @author generated
 */
@MaxLength(32)
@RequestContext(key="requestId")
@RequestContext(key="requestMethod")
@RequestContext(key="requestUri")
public interface UseCredentials extends AuditEvent {

    /**
     * File name : File name
     * @param fileName File name
     */
    @Required
    public void setFileName(String fileName);

    /**
     * Name : Name
     * @param name Name
     */
    @Required
    public void setName(String name);

    /**
     * Timestamp : Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     * @param timestamp Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     */
    @Required
    public void setTimestamp(String timestamp);

    /**
     * Usage : Usage of the entity
     * @param usage Usage of the entity
     */
    @Required
    public void setUsage(String usage);

}