package io.jenkins.plugins.audit.event;

import java.util.List;
import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.Required;

/**
 * Update Node
 * @author generated
 */
@MaxLength(32)
@RequestContext(key="requestId")
@RequestContext(key="requestMethod")
@RequestContext(key="requestUri")
public interface UpdateNode extends AuditEvent {

    /**
     * Node Name : Name of the node where action took place
     * @param nodeName Name of the node where action took place
     */
    @Required
    public void setNodeName(String nodeName);

    /**
     * Old Node Name : Name of the old node which is updated recently
     * @param oldNodeName Name of the old node which is updated recently
     */
    public void setOldNodeName(String oldNodeName);

    /**
     * Timestamp : Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     * @param timestamp Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     */
    @Required
    public void setTimestamp(String timestamp);

    /**
     * UserId : Id of the User
     * @param userId Id of the User
     */
    public void setUserId(String userId);

}