package io.jenkins.plugins.audit.event;

import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.Required;

/**
 * User updates API key(s)
 * @author generated
 */
@MaxLength(32)
@RequestContext(key="requestId")
@RequestContext(key="requestMethod")
@RequestContext(key="requestUri")
public interface UpdateKey extends AuditEvent {

    /**
     * Timestamp : Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     * @param timestamp Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     */
    @Required
    public void setTimestamp(String timestamp);

    /**
     * UserId : Id of the User
     * @param userId Id of the User
     */
    @Required
    public void setUserId(String userId);

}