package io.jenkins.plugins.audit.event;

import java.util.List;
import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.Required;

/**
 * Copy Item
 * @author generated
 */
@MaxLength(32)
@RequestContext(key="requestId")
@RequestContext(key="requestMethod")
@RequestContext(key="requestUri")
public interface CopyItem extends AuditEvent {

    /**
     * Item Name : Item Name
     * @param itemName Item Name
     */
    @Required
    public void setItemName(String itemName);

    /**
     * Item URI : Contains the original item URI
     * @param itemUri Contains the original item URI
     */
    @Required
    public void setItemUri(String itemUri);

    /**
     * Source Item URI : Contains the source item URI of the copied item
     * @param sourceItemUri Contains the source item URI of the copied item
     */
    @Required
    public void setSourceItemUri(String sourceItemUri);

    /**
     * Timestamp : Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     * @param timestamp Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     */
    @Required
    public void setTimestamp(String timestamp);

    /**
     * UserId : Id of the User
     * @param userId Id of the User
     */
    @Required
    public void setUserId(String userId);

}