package io.jenkins.plugins.audit.event;

import java.util.List;
import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.Required;

/**
 * Start of the Build
 * @author generated
 */
@MaxLength(32)
@RequestContext(key="requestId")
@RequestContext(key="requestMethod")
@RequestContext(key="requestUri")
public interface BuildStart extends AuditEvent {

    /**
     * Build Number : Build number
     * @param buildNumber Build number
     */
    @Required
    public void setBuildNumber(int buildNumber);

    /**
     * Cause : The cause for the occurance of an action
     * @param cause The cause for the occurance of an action
     */
    @Required
    public void setCause(List<String> cause);

    /**
     * Project Name : Name of the project
     * @param projectName Name of the project
     */
    @Required
    public void setProjectName(String projectName);

    /**
     * Timestamp : Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     * @param timestamp Time of action occurrence preferably in ISO-8601 datetime format, using UTC timezone
     */
    @Required
    public void setTimestamp(String timestamp);

}