/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactory_artifacts;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryClient;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryGenericArtifactConfig;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryVirtualFile;
import io.jenkins.plugins.artifactory_artifacts.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.ArtifactManager;
import jenkins.util.VirtualFile;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public class ArtifactoryArtifactManager
extends ArtifactManager
implements StashManager.StashAwareArtifactManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryArtifactManager.class);
    private static final int UPLOAD_THREADS = 4;
    private transient Run<?, ?> build;
    private final ArtifactoryGenericArtifactConfig config;
    private transient String defaultKey;

    public ArtifactoryArtifactManager(Run<?, ?> build, ArtifactoryGenericArtifactConfig config) {
        this.config = config;
        this.build = build;
        this.onLoad(build);
    }

    public void onLoad(@NonNull Run<?, ?> build) {
        this.build = build;
        this.defaultKey = String.format("%s/%s", build.getParent().getFullName(), build.getNumber()).replace("%2F", "/");
    }

    public void archive(FilePath workspace, Launcher launcher, BuildListener listener, Map<String, String> artifacts) throws IOException, InterruptedException {
        if (artifacts.isEmpty()) {
            return;
        }
        ArrayList<UploadFile> files = new ArrayList<UploadFile>();
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            String path = "artifacts/" + entry.getKey();
            String filePath = this.getFilePath(path);
            files.add(new UploadFile(entry.getValue(), filePath));
        }
        workspace.act((FilePath.FileCallable)new UploadToArtifactoryStorage(this.buildArtifactoryConfig(), files));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete() throws IOException, InterruptedException {
        String virtualPath = this.getFilePath("");
        LOGGER.trace(String.format("Deleting %s...", virtualPath));
        try (ArtifactoryClient client = this.buildArtifactoryClient();){
            if (!client.isFile(virtualPath) && !client.isFolder(virtualPath)) {
                LOGGER.debug(String.format("No file or folder found at %s", virtualPath));
                boolean bl = false;
                return bl;
            }
            client.deleteArtifact(virtualPath);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to delete %s", virtualPath), (Throwable)e);
            return false;
        }
        LOGGER.trace(String.format("Deleted %s", virtualPath));
        return true;
    }

    public VirtualFile root() {
        return new ArtifactoryVirtualFile(this.getFilePath("artifacts"), this.build);
    }

    public void stash(@NonNull String name, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener, String includes, String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        String path = this.getFilePath("stashes/" + name + ".tgz");
        FilePath tempDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempDir == null) {
            throw new AbortException("Could not make temporary directory in " + String.valueOf(workspace));
        }
        workspace.act((FilePath.FileCallable)new Stash(this.buildArtifactoryConfig(), path, includes, excludes, useDefaultExcludes, allowEmpty, tempDir.getRemote(), listener));
    }

    public void unstash(@NonNull String name, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener) throws IOException, InterruptedException {
        String path = this.getFilePath("stashes/" + name + ".tgz");
        FilePath tempDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempDir == null) {
            throw new AbortException("Could not make temporary directory in " + String.valueOf(workspace));
        }
        try (ArtifactoryClient client = this.buildArtifactoryClient();){
            if (!client.isFile(path)) {
                throw new AbortException(String.format("No such saved stash \u2018%s\u2019 found at %s", name, path));
            }
        }
        catch (Exception e) {
            throw new AbortException(String.format("Failed to stash %s from %s", name, path));
        }
        workspace.act((FilePath.FileCallable)new Unstash(this.buildArtifactoryConfig(), path, listener));
    }

    public void clearAllStashes(@NonNull TaskListener listener) throws IOException, InterruptedException {
        String virtualPath = this.getFilePath("stashes");
        LOGGER.trace(String.format("Deleting %s...", virtualPath));
        try (ArtifactoryClient client = this.buildArtifactoryClient();){
            if (client.isFolder(virtualPath)) {
                client.deleteArtifact(virtualPath);
                listener.getLogger().println("Deleted all stashes on Artifactory Storage");
                LOGGER.debug(String.format("Deleted stash %s", virtualPath));
            }
        }
        catch (Exception e) {
            listener.getLogger().printf("Failed to delete stashes on Artifactory Storage. Details %s%n", e.getMessage());
            LOGGER.error(String.format("Failed to delete stash on Artifactory at %s", virtualPath), (Throwable)e);
        }
    }

    public void copyAllArtifactsAndStashes(@NonNull Run<?, ?> to, @NonNull TaskListener listener) throws IOException, InterruptedException {
        LOGGER.debug(String.format("Copy all artifacts and stash to %s...", to));
        ArtifactManager artifactManager = to.pickArtifactManager();
        if (!(artifactManager instanceof ArtifactoryArtifactManager)) {
            throw new AbortException(String.format("Cannot copy artifacts and stashes to %s using %s", to, artifactManager.getClass()));
        }
        ArtifactoryArtifactManager artifactoryArtifactManager = (ArtifactoryArtifactManager)artifactManager;
        try (ArtifactoryClient client = this.buildArtifactoryClient();){
            String stashedPath = this.getFilePath("stashes");
            String artifactPath = this.getFilePath("artifacts");
            String toStashedPath = artifactoryArtifactManager.getFilePath("stashes");
            String toArtifactPath = artifactoryArtifactManager.getFilePath("artifacts");
            if (client.isFolder(artifactPath)) {
                LOGGER.debug(String.format("Copying artifacts from %s to %s", artifactPath, toArtifactPath));
                listener.getLogger().println(String.format("Copying artifacts from %s to %s", artifactPath, toArtifactPath));
                client.copy(artifactPath, toArtifactPath);
            }
            if (client.isFolder(stashedPath)) {
                listener.getLogger().println(String.format("Copying stashes from %s to %s", stashedPath, toStashedPath));
                LOGGER.debug(String.format("Copying stashes from %s to %s", stashedPath, toStashedPath));
                client.copy(stashedPath, toStashedPath);
            }
        }
        catch (Exception e) {
            listener.getLogger().printf("Failed to copy artifact and stashes on Artifactory Storage. Details %s%n", e.getMessage());
            throw new IOException(e);
        }
    }

    private String getFilePath(String path) {
        return Utils.getFilePath(this.defaultKey, path);
    }

    private ArtifactoryClient buildArtifactoryClient() {
        return new ArtifactoryClient(this.config.getServerUrl(), this.config.getRepository(), (UsernamePasswordCredentials)Utils.getCredentials());
    }

    private ArtifactoryClient.ArtifactoryConfig buildArtifactoryConfig() {
        return new ArtifactoryClient.ArtifactoryConfig(this.config.getServerUrl(), this.config.getRepository(), (UsernamePasswordCredentials)Utils.getCredentials(), this.config.getMaxUploadRetries(), this.config.getRetryDelaySeconds());
    }

    private static void executeWithRetry(RetryableOperation operation, String operationName, int maxRetries, long retryDelayMs, String failureMessage) throws RuntimeException {
        int maxAttempts = Math.max(1, maxRetries);
        int attempt = 0;
        while (attempt < maxAttempts) {
            try {
                LOGGER.debug(String.format("%s (attempt %d/%d)", operationName, attempt + 1, maxAttempts));
                operation.execute();
                return;
            }
            catch (Exception e) {
                if (++attempt >= maxAttempts) {
                    String message = maxRetries == 0 ? String.format("%s on first attempt (no retries configured)", failureMessage) : String.format("%s after %d attempts", failureMessage, maxRetries);
                    LOGGER.error(message, (Throwable)e);
                    throw new RuntimeException(String.format("%s: %s", message, e.getMessage()), e);
                }
                LOGGER.warn(String.format("%s attempt %d failed, retrying in %dms: %s", operationName, attempt, retryDelayMs, e.getMessage()));
                try {
                    Thread.sleep(retryDelayMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(operationName + " interrupted during retry delay", ie);
                }
            }
        }
    }

    private static class UploadFile
    implements Serializable {
        private final String name;
        private final String url;

        public UploadFile(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }

    private static class UploadToArtifactoryStorage
    extends MasterToSlaveFileCallable<Void> {
        private final List<UploadFile> files;
        private final ArtifactoryClient.ArtifactoryConfig config;

        public UploadToArtifactoryStorage(ArtifactoryClient.ArtifactoryConfig config, List<UploadFile> files) {
            this.config = config;
            this.files = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File folder, VirtualChannel channel) throws IOException, InterruptedException {
            try (ArtifactoryClient client = new ArtifactoryClient(this.config);){
                ExecutorService executor = Executors.newFixedThreadPool(4);
                try {
                    CompletableFuture<Void> allUploads = CompletableFuture.allOf((CompletableFuture[])this.files.stream().map(file -> CompletableFuture.runAsync(() -> this.upload(client, folder, (UploadFile)file, this.config), executor)).toArray(CompletableFuture[]::new));
                    allUploads.get();
                }
                finally {
                    executor.shutdown();
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to upload files to Artifactory", (Throwable)e);
                throw new AbortException("Unable to upload files to Artifactory. Details: " + e.getMessage());
            }
            return null;
        }

        private void upload(ArtifactoryClient client, File folder, UploadFile uploadFile, ArtifactoryClient.ArtifactoryConfig config) {
            File sourceFile = new File(folder, uploadFile.getName());
            String filePath = sourceFile.toPath().toString();
            String targetUrl = uploadFile.getUrl();
            ArtifactoryArtifactManager.executeWithRetry(() -> client.uploadArtifact(sourceFile.toPath(), targetUrl), "Uploading " + filePath + " to " + targetUrl, config.getMaxUploadRetries(), (long)config.getRetryDelaySeconds() * 1000L, "Failed to upload " + filePath);
            LOGGER.debug(String.format("Successfully uploaded %s to %s", filePath, targetUrl));
        }
    }

    private static final class Stash
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final ArtifactoryClient.ArtifactoryConfig config;
        private final String path;
        private final String includes;
        private final String excludes;
        private final boolean useDefaultExcludes;
        private final boolean allowEmpty;
        private final String tempDir;
        private final TaskListener listener;

        public Stash(ArtifactoryClient.ArtifactoryConfig config, String path, String includes, String excludes, boolean useDefaultExcludes, boolean allowEmpty, String tempDir, TaskListener listener) throws IOException {
            this.config = config;
            this.path = path;
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
            this.allowEmpty = allowEmpty;
            this.tempDir = tempDir;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Path tempDirP = Paths.get(this.tempDir, new String[0]);
            Files.createDirectories(tempDirP, new FileAttribute[0]);
            Path tmp = Files.createTempFile(tempDirP, "stash", ".tgz", new FileAttribute[0]);
            try {
                int count;
                try (OutputStream os = Files.newOutputStream(tmp, new OpenOption[0]);){
                    count = new FilePath(f).archive(ArchiverFactory.TARGZ, os, (DirScanner)new DirScanner.Glob(Util.fixEmpty((String)this.includes) == null ? "**" : this.includes, this.excludes, this.useDefaultExcludes));
                }
                catch (InvalidPathException e) {
                    throw new IOException(e);
                }
                if (count == 0 && !this.allowEmpty) {
                    throw new AbortException("No files included in stash");
                }
                try {
                    ArtifactoryArtifactManager.executeWithRetry(() -> {
                        try (ArtifactoryClient client = new ArtifactoryClient(this.config);){
                            client.uploadArtifact(tmp, this.path);
                        }
                    }, "Uploading stash to " + this.path, this.config.getMaxUploadRetries(), (long)this.config.getRetryDelaySeconds() * 1000L, "Unable to stash files to Artifactory");
                    this.listener.getLogger().printf("Stashed %d file(s) to %s%n", count, this.path);
                }
                catch (RuntimeException e) {
                    String message = this.config.getMaxUploadRetries() == 0 ? "Unable to stash files to Artifactory on first attempt (no retries configured)" : "Unable to stash files to Artifactory after " + this.config.getMaxUploadRetries() + " attempts";
                    throw new AbortException(message + ". Details: " + e.getMessage());
                }
            }
            finally {
                this.listener.getLogger().flush();
                Files.delete(tmp);
            }
            return null;
        }
    }

    private static final class Unstash
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final ArtifactoryClient.ArtifactoryConfig config;
        private final String path;
        private final TaskListener listener;

        public Unstash(ArtifactoryClient.ArtifactoryConfig config, String path, TaskListener listener) throws IOException {
            this.config = config;
            this.path = path;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try (ArtifactoryClient client = new ArtifactoryClient(this.config);){
                try (InputStream is = client.downloadArtifact(this.path);){
                    new FilePath(f).untarFrom(is, FilePath.TarCompression.GZIP);
                }
                finally {
                    this.listener.getLogger().flush();
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to unstash files from Artifactory", (Throwable)e);
                throw new AbortException("Unable to unstash files from Artifactory. Details: " + e.getMessage());
            }
            return null;
        }
    }

    @FunctionalInterface
    private static interface RetryableOperation {
        public void execute() throws Exception;
    }

    @Extension
    public static final class ArtifactoryItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            ArtifactoryGenericArtifactConfig config = Utils.getArtifactConfig();
            if (config == null) {
                return;
            }
            String path = Utils.stripTrailingSlash(Utils.getFilePath(item.getFullName(), ""));
            LOGGER.debug(String.format("Checking if %s must be deleted on Artifactory Storage", path));
            try (ArtifactoryClient client = new ArtifactoryClient(config.getServerUrl(), config.getRepository(), (UsernamePasswordCredentials)Utils.getCredentials());){
                if (client.isFolder(path)) {
                    LOGGER.debug(String.format("Deleting %s...", path));
                    client.deleteArtifact(path);
                    LOGGER.debug(String.format("Deleted %s on Artifactory Storage", path));
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to delete %s", path), (Throwable)e);
            }
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            ArtifactoryGenericArtifactConfig config = Utils.getArtifactConfig();
            String sourcePath = Utils.stripTrailingSlash(Utils.getFilePath(oldFullName, ""));
            String targetPath = Utils.stripTrailingSlash(Utils.getFilePath(newFullName, ""));
            LOGGER.debug(String.format("Checking if %s must be moved to %s on Artifactory Storage", sourcePath, targetPath));
            try (ArtifactoryClient client = new ArtifactoryClient(config.getServerUrl(), config.getRepository(), (UsernamePasswordCredentials)Utils.getCredentials());){
                if (client.isFolder(sourcePath)) {
                    LOGGER.debug(String.format("Moving %s...", sourcePath));
                    client.move(sourcePath, targetPath);
                    LOGGER.debug(String.format("Moving %s on Artifactory Storage", targetPath));
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to move %s to %s. Artifactory Pro is needed", sourcePath, targetPath));
            }
        }
    }
}

