/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactory_artifacts;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.remoting.Callable;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryAbstractVirtualFile;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryClient;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryGenericArtifactConfig;
import io.jenkins.plugins.artifactory_artifacts.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.util.VirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactoryVirtualFile
extends ArtifactoryAbstractVirtualFile {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryVirtualFile.class);
    private final String key;
    private final transient Run<?, ?> build;
    private final ArtifactoryClient.FileInfo fileInfo;
    private transient ArtifactoryClient cachedClient;

    public ArtifactoryVirtualFile(String key, Run<?, ?> build) {
        this.key = key;
        this.build = build;
        this.fileInfo = null;
    }

    public ArtifactoryVirtualFile(ArtifactoryClient.FileInfo fileInfo, Run<?, ?> build) {
        this.key = fileInfo.getPath();
        this.build = build;
        this.fileInfo = fileInfo;
    }

    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getName() {
        String localKey = Utils.stripTrailingSlash(this.key);
        int lastSlash = (localKey = localKey.replaceFirst(".*/artifacts/", "")).lastIndexOf(47);
        String result = lastSlash >= 0 ? localKey.substring(lastSlash + 1) : localKey;
        return result;
    }

    @NonNull
    public URI toURI() {
        try {
            return new URI(Utils.getUrl(this.key));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckForNull
    public URL toExternalURL() throws IOException {
        return new URL(Utils.getUrl(this.key));
    }

    public VirtualFile getParent() {
        return new ArtifactoryVirtualFile(this.key.replaceFirst("/[^/]+$", ""), this.build);
    }

    public boolean isDirectory() throws IOException {
        if (this.fileInfo != null) {
            return this.fileInfo.isDirectory();
        }
        String keyWithNoSlash = Utils.stripTrailingSlash(this.key);
        if (keyWithNoSlash.endsWith("/*view*")) {
            return false;
        }
        try {
            return this.buildArtifactoryClient().isFolder(this.key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to check if %s is a directory", this.key), (Throwable)e);
            return false;
        }
    }

    public boolean isFile() throws IOException {
        if (this.fileInfo != null) {
            return this.fileInfo.isFile();
        }
        String keyS = this.key + "/";
        if (keyS.endsWith("/*view*/")) {
            return false;
        }
        try {
            return this.buildArtifactoryClient().isFile(this.key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to check if %s is a file", this.key), (Throwable)e);
            return false;
        }
    }

    public boolean exists() throws IOException {
        return this.isDirectory() || this.isFile();
    }

    @NonNull
    public VirtualFile[] list() throws IOException {
        String prefix = Utils.stripTrailingSlash(this.key) + "/";
        List<VirtualFile> files = this.listFilesFromPrefix(prefix);
        if (files.isEmpty()) {
            return new VirtualFile[0];
        }
        return files.toArray(new VirtualFile[0]);
    }

    @NonNull
    public VirtualFile child(@NonNull String name) {
        String joinedKey = Utils.stripTrailingSlash(this.key) + "/" + name;
        return new ArtifactoryVirtualFile(joinedKey, this.build);
    }

    public long length() throws IOException {
        if (this.fileInfo != null) {
            return this.fileInfo.getSize();
        }
        try {
            return this.buildArtifactoryClient().size(this.key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to get size of %s", this.key), (Throwable)e);
            return 0L;
        }
    }

    public long lastModified() throws IOException {
        if (this.fileInfo != null) {
            return this.fileInfo.getLastUpdated();
        }
        try {
            return this.buildArtifactoryClient().lastUpdated(this.key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to get last updated time of %s", this.key), (Throwable)e);
            return 0L;
        }
    }

    public boolean canRead() throws IOException {
        return true;
    }

    public InputStream open() throws IOException {
        LOGGER.debug(String.format("Opening %s...", this.key));
        if (this.isDirectory()) {
            throw new FileNotFoundException("Cannot open it because it is a directory.");
        }
        if (!this.isFile()) {
            throw new FileNotFoundException("Cannot open it because it is not a file.");
        }
        try {
            return this.buildArtifactoryClient().downloadArtifact(this.key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to open %s", this.key), (Throwable)e);
            throw new IOException(e);
        }
    }

    public <V> V run(Callable<V, IOException> callable) throws IOException {
        try {
            Object object = callable.call();
            return (V)object;
        }
        finally {
            this.closeArtifactoryClient();
        }
    }

    private ArtifactoryClient buildArtifactoryClient() {
        if (this.cachedClient == null) {
            ArtifactoryGenericArtifactConfig config = Utils.getArtifactConfig();
            this.cachedClient = new ArtifactoryClient(config.getServerUrl(), config.getRepository(), (UsernamePasswordCredentials)Utils.getCredentials());
        }
        return this.cachedClient;
    }

    private void closeArtifactoryClient() {
        if (this.cachedClient != null) {
            try {
                this.cachedClient.close();
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to close Artifactory client", new Object[0]), (Throwable)e);
            }
            this.cachedClient = null;
        }
    }

    private List<VirtualFile> listFilesFromPrefix(String prefix) {
        try {
            List<ArtifactoryClient.FileInfo> children = this.buildArtifactoryClient().list(prefix);
            return children.stream().map(fileInfo -> new ArtifactoryVirtualFile((ArtifactoryClient.FileInfo)fileInfo, this.build)).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to list files from prefix %s", prefix), (Throwable)e);
            return List.of();
        }
    }
}

