/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactory_artifacts;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryArtifactManager;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryGenericArtifactConfig;
import io.jenkins.plugins.artifactory_artifacts.Utils;
import jenkins.model.ArtifactManager;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.ArtifactManagerFactoryDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class ArtifactoryArtifactManagerFactory
extends ArtifactManagerFactory {
    private final ArtifactoryGenericArtifactConfig config;

    @DataBoundConstructor
    public ArtifactoryArtifactManagerFactory(ArtifactoryGenericArtifactConfig config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        this.config = config;
    }

    @CheckForNull
    public ArtifactManager managerFor(Run<?, ?> build) {
        return new ArtifactoryArtifactManager(build, Utils.getArtifactConfig());
    }

    public ArtifactoryGenericArtifactConfig getConfig() {
        return this.config;
    }

    @Extension
    @Symbol(value={"artifactory"})
    public static final class DescriptorImpl
    extends ArtifactManagerFactoryDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Artifactory Artifact Storage";
        }
    }
}

