/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifact_manager_jclouds.s3;

import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.google.common.base.Supplier;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import io.jenkins.plugins.artifact_manager_jclouds.BlobStoreProvider;
import io.jenkins.plugins.artifact_manager_jclouds.BlobStoreProviderDescriptor;
import io.jenkins.plugins.artifact_manager_jclouds.s3.S3BlobStoreConfig;
import io.jenkins.plugins.aws.global_configuration.CredentialsAwsGlobalConfiguration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.FIPS140;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.aws.s3.AWSS3ProviderMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.domain.Credentials;
import org.jclouds.osgi.ProviderRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

@Restricted(value={NoExternalUse.class})
public class S3BlobStore
extends BlobStoreProvider {
    private static final Logger LOGGER = Logger.getLogger(S3BlobStore.class.getName());
    private static final long serialVersionUID = -8864075675579867370L;
    static boolean BREAK_CREDS;

    @DataBoundConstructor
    public S3BlobStore() {
    }

    @Override
    public String getPrefix() {
        return Util.fixNull((String)this.getConfiguration().getPrefix());
    }

    @Override
    public String getContainer() {
        return this.getConfiguration().getContainer();
    }

    public String getRegion() {
        return this.getConfiguration().getRegion().id();
    }

    public S3BlobStoreConfig getConfiguration() {
        return S3BlobStoreConfig.get();
    }

    @Override
    public boolean isDeleteArtifacts() {
        return this.getConfiguration().isDeleteArtifacts();
    }

    @Override
    public boolean isDeleteStashes() {
        return this.getConfiguration().isDeleteStashes();
    }

    @Override
    public BlobStoreContext getContext() throws IOException {
        LOGGER.log(Level.FINEST, "Building context");
        ProviderRegistry.registerProvider((ProviderMetadata)AWSS3ProviderMetadata.builder().build());
        try {
            boolean hasCustomEndpoint;
            Properties props = new Properties();
            String resolvedCustomEndpoint = this.getConfiguration().getResolvedCustomEndpoint();
            boolean bl = hasCustomEndpoint = resolvedCustomEndpoint == null || !resolvedCustomEndpoint.isBlank();
            if (!this.getRegion().isBlank()) {
                props.setProperty("jclouds.regions", this.getRegion());
            }
            if (hasCustomEndpoint) {
                props.setProperty("endpoint", resolvedCustomEndpoint);
            }
            props.setProperty("jclouds.s3.virtual-host-buckets", Boolean.toString(!this.getConfiguration().getUsePathStyleUrl()));
            ContextBuilder builder = ContextBuilder.newBuilder((String)"aws-s3").credentialsSupplier(this.getCredentialsSupplier()).overrides(props);
            if (hasCustomEndpoint) {
                builder = builder.endpoint(resolvedCustomEndpoint);
            }
            return (BlobStoreContext)builder.buildView(BlobStoreContext.class);
        }
        catch (NoSuchElementException x) {
            throw new IOException(x);
        }
    }

    private Supplier<Credentials> getCredentialsSupplier() throws IOException {
        String sessionToken;
        String secretKey;
        String accessKeyId;
        if (this.getConfiguration().getDisableSessionToken()) {
            AmazonWebServicesCredentials amazonWebServicesCredentials = CredentialsAwsGlobalConfiguration.get().getCredentials();
            if (amazonWebServicesCredentials == null) {
                throw new IOException("No static AWS credentials found");
            }
            AwsCredentials awsCredentials = amazonWebServicesCredentials.resolveCredentials();
            accessKeyId = awsCredentials.accessKeyId();
            secretKey = awsCredentials.secretAccessKey();
            sessionToken = "";
        } else {
            AwsSessionCredentials awsSessionCredentials = CredentialsAwsGlobalConfiguration.get().sessionCredentials(this.getRegion(), CredentialsAwsGlobalConfiguration.get().getCredentialsId());
            if (awsSessionCredentials != null) {
                accessKeyId = awsSessionCredentials.accessKeyId();
                secretKey = awsSessionCredentials.secretAccessKey();
                sessionToken = awsSessionCredentials.sessionToken();
            } else {
                throw new IOException("No session AWS credentials found");
            }
        }
        if (BREAK_CREDS) {
            sessionToken = "<broken>";
        }
        SessionCredentials sessionCredentials = SessionCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretKey).sessionToken(sessionToken).build();
        return () -> sessionCredentials;
    }

    @Override
    @NonNull
    public URI toURI(@NonNull String container, @NonNull String key) {
        URI uRI;
        block8: {
            S3Client s3Client = (S3Client)this.getConfiguration().getAmazonS3ClientBuilder().build();
            try {
                GetUrlRequest getUrlRequest = (GetUrlRequest)GetUrlRequest.builder().key(key).bucket(container).build();
                URI uri = s3Client.utilities().getUrl(getUrlRequest).toURI();
                LOGGER.fine(() -> container + " / " + key + " \u2192 " + String.valueOf(uri));
                uRI = uri;
                if (s3Client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s3Client != null) {
                        try {
                            s3Client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
            }
            s3Client.close();
        }
        return uRI;
    }

    public S3Presigner getS3Presigner(S3Client s3Client) {
        String customRegion;
        String customEndpoint = this.getConfiguration().getResolvedCustomEndpoint();
        S3Presigner.Builder presignerBuilder = S3Presigner.builder().fipsEnabled(Boolean.valueOf(FIPS140.useCompliantAlgorithms())).region(this.getConfiguration().getRegion()).credentialsProvider((AwsCredentialsProvider)CredentialsAwsGlobalConfiguration.get().getCredentials()).s3Client(s3Client);
        if (customEndpoint != null && !customEndpoint.isBlank()) {
            presignerBuilder.endpointOverride(URI.create(customEndpoint));
        }
        if ((customRegion = this.getConfiguration().getCustomSigningRegion()).isBlank()) {
            customRegion = this.getConfiguration().getRegion().id();
        }
        if (!customRegion.isBlank()) {
            presignerBuilder.region(Region.of((String)customRegion));
        }
        S3Configuration s3Configuration = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(this.getConfiguration().getUsePathStyleUrl())).accelerateModeEnabled(Boolean.valueOf(this.getConfiguration().getUseTransferAcceleration())).build();
        presignerBuilder.serviceConfiguration(s3Configuration);
        return presignerBuilder.build();
    }

    private URL toExternalURL(@NonNull Blob blob, @NonNull BlobStoreProvider.HttpMethod httpMethod, S3Presigner presigner) throws IOException {
        Duration expiration = Duration.ofHours(1L);
        String container = blob.getMetadata().getContainer();
        String name = blob.getMetadata().getName();
        LOGGER.log(Level.FINE, "Generating presigned URL for {0} / {1} for method {2}", new Object[]{container, name, httpMethod});
        switch (httpMethod) {
            case PUT: {
                String contentType = blob.getMetadata().getContentMetadata().getContentType();
                PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(container).contentType(contentType).key(name).build();
                PutObjectPresignRequest putObjectPresignRequest = PutObjectPresignRequest.builder().signatureDuration(expiration).putObjectRequest(putObjectRequest).build();
                return presigner.presignPutObject(putObjectPresignRequest).url();
            }
            case GET: {
                GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(container).key(name).build();
                GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(expiration).getObjectRequest(getObjectRequest).build();
                return presigner.presignGetObject(getObjectPresignRequest).url();
            }
        }
        throw new IOException("HTTP Method " + String.valueOf((Object)httpMethod) + " not supported for S3");
    }

    @Override
    public URL toExternalURL(@NonNull Blob blob, @NonNull BlobStoreProvider.HttpMethod httpMethod) throws IOException {
        try (S3Client s3Client = (S3Client)this.getConfiguration().getAmazonS3ClientBuilderWithCredentials().build();){
            URL uRL;
            block12: {
                S3Presigner presigner = this.getS3Presigner(s3Client);
                try {
                    uRL = this.toExternalURL(blob, httpMethod, presigner);
                    if (presigner == null) break block12;
                }
                catch (Throwable throwable) {
                    if (presigner != null) {
                        try {
                            presigner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                presigner.close();
            }
            return uRL;
        }
    }

    @Override
    public Map<String, URL> artifactUrls(Map<String, String> artifacts, Map<String, String> contentTypes, BlobStore blobStore, String key) throws IOException {
        HashMap<String, URL> artifactUrls = new HashMap<String, URL>();
        try (S3Client s3Client = (S3Client)this.getConfiguration().getAmazonS3ClientBuilderWithCredentials().build();
             S3Presigner s3Presigner = this.getS3Presigner(s3Client);){
            for (Map.Entry<String, String> entry : artifacts.entrySet()) {
                String path = "artifacts/" + entry.getKey();
                String blobPath = this.getBlobPath(key, path);
                Blob blob = blobStore.blobBuilder(blobPath).build();
                blob.getMetadata().setContainer(this.getContainer());
                blob.getMetadata().getContentMetadata().setContentType(contentTypes.get(entry.getValue()));
                artifactUrls.put(entry.getValue(), this.toExternalURL(blob, BlobStoreProvider.HttpMethod.PUT, s3Presigner));
            }
        }
        return artifactUrls;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3BlobStore{");
        sb.append("container='").append(this.getContainer()).append('\'');
        sb.append(", prefix='").append(this.getPrefix()).append('\'');
        sb.append(", region='").append(this.getRegion()).append('\'');
        sb.append(", deleteArtifacts='").append(this.isDeleteArtifacts()).append('\'');
        sb.append(", deleteStashes='").append(this.isDeleteStashes()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Symbol(value={"s3"})
    @Extension
    public static final class DescriptorImpl
    extends BlobStoreProviderDescriptor {
        public String getDisplayName() {
            return "Amazon S3";
        }

        public boolean isConfigured() {
            return !S3BlobStoreConfig.get().getContainer().isBlank();
        }
    }
}

