/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifact_manager_jclouds;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.remoting.Callable;
import io.jenkins.plugins.artifact_manager_jclouds.BlobStoreProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import jenkins.util.VirtualFile;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStores;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.rest.AuthorizationException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class JCloudsVirtualFile
extends VirtualFile {
    private static final long serialVersionUID = -5126878907895121335L;
    private static final Logger LOGGER = Logger.getLogger(JCloudsVirtualFile.class.getName());
    @NonNull
    private BlobStoreProvider provider;
    @NonNull
    private final String container;
    @NonNull
    private final String key;
    @CheckForNull
    private transient Blob blob;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="This field is expected to be loaded by a provider instead of deserialization.")
    @CheckForNull
    private transient BlobStoreContext context;
    private static final ThreadLocal<Map<String, Deque<CacheFrame>>> cache = ThreadLocal.withInitial(HashMap::new);

    public JCloudsVirtualFile(@NonNull BlobStoreProvider provider, @NonNull String container, @NonNull String key) {
        this.provider = provider;
        this.container = container;
        this.key = key;
        assert (!key.isEmpty());
        assert (!key.startsWith("/"));
        assert (!key.endsWith("/"));
    }

    private JCloudsVirtualFile(@NonNull JCloudsVirtualFile related, @NonNull String key) {
        this(related.provider, related.container, key);
        this.context = related.context;
    }

    @Restricted(value={NoExternalUse.class})
    BlobStoreContext getContext() throws IOException {
        if (this.context == null) {
            this.context = this.provider.getContext();
        }
        return this.context;
    }

    private String getContainer() {
        return this.container;
    }

    private String getKey() {
        return this.key;
    }

    public String getName() {
        return this.key.replaceFirst(".+/", "");
    }

    private Blob getBlob() throws IOException {
        if (this.blob == null) {
            LOGGER.log(Level.FINE, "checking for existence of blob {0} / {1}", new Object[]{this.container, this.key});
            this.blob = this.getContext().getBlobStore().getBlob(this.getContainer(), this.getKey());
            if (this.blob == null) {
                this.blob = this.getContext().getBlobStore().blobBuilder(this.getKey()).build();
                this.blob.getMetadata().setContainer(this.getContainer());
            }
        }
        return this.blob;
    }

    public URI toURI() {
        return this.provider.toURI(this.container, this.key);
    }

    public URL toExternalURL() throws IOException {
        return this.provider.toExternalURL(this.getBlob(), BlobStoreProvider.HttpMethod.GET);
    }

    public VirtualFile getParent() {
        return new JCloudsVirtualFile(this, this.key.replaceFirst("/[^/]+$", ""));
    }

    public boolean isDirectory() throws IOException {
        String keyS = this.key + "/";
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            LOGGER.log(Level.FINER, "cache hit on directory status of {0} / {1}", new Object[]{this.container, this.key});
            String relSlash = keyS.substring(frame.root.length());
            return frame.children.keySet().stream().anyMatch(f -> f.startsWith(relSlash));
        }
        LOGGER.log(Level.FINE, "checking directory status {0} / {1}", new Object[]{this.container, this.key});
        return !this.getContext().getBlobStore().list(this.getContainer(), ListContainerOptions.Builder.prefix((String)(this.key + "/"))).isEmpty();
    }

    public boolean isFile() throws IOException {
        CacheFrame frame = this.findCacheFrame(this.key);
        if (frame != null) {
            String rel = this.key.substring(frame.root.length());
            CachedMetadata metadata = frame.children.get(rel);
            LOGGER.log(Level.FINER, "cache hit on file status of {0} / {1}", new Object[]{this.container, this.key});
            return metadata != null;
        }
        LOGGER.log(Level.FINE, "checking file status {0} / {1}", new Object[]{this.container, this.key});
        return this.getBlob().getMetadata().getSize() != null;
    }

    public boolean exists() throws IOException {
        return this.isDirectory() || this.isFile();
    }

    private Iterable<StorageMetadata> listStorageMetadata(boolean recursive) throws IOException {
        ListContainerOptions options = ListContainerOptions.Builder.prefix((String)(this.key + "/"));
        if (recursive) {
            options.recursive();
        }
        return BlobStores.listAll((BlobStore)this.getContext().getBlobStore(), (String)this.getContainer(), (ListContainerOptions)options);
    }

    public VirtualFile[] list() throws IOException {
        Object[] list;
        String keyS = this.key + "/";
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            LOGGER.log(Level.FINER, "cache hit on listing of {0} / {1}", new Object[]{this.container, this.key});
            String relSlash = keyS.substring(frame.root.length());
            return (VirtualFile[])frame.children.keySet().stream().filter(f -> f.startsWith(relSlash)).map(f -> f.substring(relSlash.length()).replaceFirst("/.+", "")).distinct().map(simple -> new JCloudsVirtualFile(this, keyS + simple)).toArray(VirtualFile[]::new);
        }
        try {
            list = (VirtualFile[])StreamSupport.stream(this.listStorageMetadata(false).spliterator(), false).map(meta -> new JCloudsVirtualFile(this, meta.getName().replaceFirst("/$", ""))).toArray(VirtualFile[]::new);
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        LOGGER.log(Level.FINEST, "Listing files from {0} {1}: {2}", new String[]{this.getContainer(), this.getKey(), Arrays.toString(list)});
        return list;
    }

    public VirtualFile child(String name) {
        return new JCloudsVirtualFile(this, this.key + "/" + name);
    }

    public long length() throws IOException {
        CacheFrame frame = this.findCacheFrame(this.key);
        if (frame != null) {
            String rel = this.key.substring(frame.root.length());
            CachedMetadata metadata = frame.children.get(rel);
            LOGGER.log(Level.FINER, "cache hit on length of {0} / {1}", new Object[]{this.container, this.key});
            return metadata != null ? metadata.length : 0L;
        }
        LOGGER.log(Level.FINE, "checking length {0} / {1}", new Object[]{this.container, this.key});
        MutableBlobMetadata metadata = this.getBlob().getMetadata();
        Long size = metadata == null ? Long.valueOf(0L) : metadata.getSize();
        return size == null ? 0L : size;
    }

    public long lastModified() throws IOException {
        CacheFrame frame = this.findCacheFrame(this.key);
        if (frame != null) {
            String rel = this.key.substring(frame.root.length());
            CachedMetadata metadata = frame.children.get(rel);
            LOGGER.log(Level.FINER, "cache hit on lastModified of {0} / {1}", new Object[]{this.container, this.key});
            return metadata != null ? metadata.lastModified : 0L;
        }
        LOGGER.log(Level.FINE, "checking modification time {0} / {1}", new Object[]{this.container, this.key});
        MutableBlobMetadata metadata = this.getBlob().getMetadata();
        return metadata == null || metadata.getLastModified() == null ? 0L : metadata.getLastModified().getTime();
    }

    public boolean canRead() throws IOException {
        return true;
    }

    public InputStream open() throws IOException {
        LOGGER.log(Level.FINE, "reading {0} / {1}", new Object[]{this.container, this.key});
        if (this.isDirectory()) {
            throw new FileNotFoundException(String.format("%s/%s (Is a directory)", this.getContainer(), this.getKey()));
        }
        if (!this.isFile()) {
            throw new FileNotFoundException(String.format("%s/%s (No such file or directory)", this.getContainer(), this.getKey()));
        }
        return this.getBlob().getPayload().openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V run(Callable<V, IOException> callable) throws IOException {
        Object object;
        LOGGER.log(Level.FINE, "enter cache {0} / {1}", new Object[]{this.container, this.key});
        Deque<CacheFrame> stack = this.cacheFrames();
        HashMap<String, CachedMetadata> saved = new HashMap<String, CachedMetadata>();
        int prefixLength = this.key.length() + 1;
        try {
            for (StorageMetadata sm : this.listStorageMetadata(true)) {
                Long length = sm.getSize();
                if (length == null) continue;
                Date lastModified = sm.getLastModified();
                saved.put(sm.getName().substring(prefixLength), new CachedMetadata(length, lastModified != null ? lastModified.getTime() : 0L));
            }
        }
        catch (AuthorizationException e) {
            String cause = e.getCause() != null ? e.getCause().getMessage() : "";
            throw new AbortException(String.format("Authorization failed: %s %s", e.getMessage(), cause));
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        stack.push(new CacheFrame(this.key + "/", saved));
        try {
            LOGGER.log(Level.FINE, "using cache {0} / {1}: {2} file entries", new Object[]{this.container, this.key, saved.size()});
            object = callable.call();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.FINE, "exit cache {0} / {1}", new Object[]{this.container, this.key});
            stack.pop();
            throw throwable;
        }
        LOGGER.log(Level.FINE, "exit cache {0} / {1}", new Object[]{this.container, this.key});
        stack.pop();
        return (V)object;
    }

    private Deque<CacheFrame> cacheFrames() {
        return cache.get().computeIfAbsent(this.container, c -> new ArrayDeque());
    }

    @CheckForNull
    private CacheFrame findCacheFrame(String key) {
        return this.cacheFrames().stream().filter(frame -> key.startsWith(frame.root)).findFirst().orElse(null);
    }

    public static boolean delete(BlobStoreProvider provider, BlobStore blobStore, String prefix) throws IOException, InterruptedException {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            for (StorageMetadata sm : BlobStores.listAll((BlobStore)blobStore, (String)provider.getContainer(), (ListContainerOptions)ListContainerOptions.Builder.prefix((String)prefix).recursive())) {
                String path = sm.getName();
                if (!path.startsWith(prefix)) {
                    LOGGER.warning(() -> path + " does not start with " + prefix);
                    continue;
                }
                paths.add(path);
            }
            if (paths.isEmpty()) {
                LOGGER.log(Level.FINE, "nothing to delete under {0}", prefix);
                return false;
            }
            LOGGER.log(Level.FINE, "deleting {0} blobs under {1}", new Object[]{paths.size(), prefix});
            blobStore.removeBlobs(provider.getContainer(), paths);
            return true;
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
    }

    private static final class CacheFrame {
        final String root;
        final Map<String, CachedMetadata> children;

        CacheFrame(String root, Map<String, CachedMetadata> children) {
            this.root = root;
            this.children = children;
        }
    }

    private static final class CachedMetadata {
        final long length;
        final long lastModified;

        CachedMetadata(long length, long lastModified) {
            this.length = length;
            this.lastModified = lastModified;
        }
    }
}

