/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifact_manager_jclouds.s3;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Failure;
import hudson.util.FormValidation;
import io.jenkins.plugins.artifact_manager_jclouds.JCloudsVirtualFile;
import io.jenkins.plugins.artifact_manager_jclouds.s3.S3BlobStore;
import io.jenkins.plugins.aws.global_configuration.AbstractAwsGlobalConfiguration;
import io.jenkins.plugins.aws.global_configuration.CredentialsAwsGlobalConfiguration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.security.FIPS140;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;

@Symbol(value={"s3"})
@Extension
public final class S3BlobStoreConfig
extends AbstractAwsGlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(S3BlobStoreConfig.class.getName());
    private static final String BUCKET_REGEXP = "^([a-z]|(\\d(?!\\d{0,2}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})))([a-z\\d]|(\\.(?!(\\.|-)))|(-(?!\\.))){1,61}[a-z\\d\\.]$";
    private static final Pattern bucketPattern = Pattern.compile("^([a-z]|(\\d(?!\\d{0,2}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})))([a-z\\d]|(\\.(?!(\\.|-)))|(-(?!\\.))){1,61}[a-z\\d\\.]$");
    private static final String ENDPOINT_REGEXP = "^[a-z0-9][a-z0-9-.]{0,}(?::[0-9]{1,5})?$";
    private static final Pattern endPointPattern = Pattern.compile("^[a-z0-9][a-z0-9-.]{0,}(?::[0-9]{1,5})?$", 2);
    private static boolean DELETE_ARTIFACTS = Boolean.getBoolean(S3BlobStoreConfig.class.getName() + ".deleteArtifacts");
    private static boolean DELETE_STASHES = Boolean.getBoolean(S3BlobStoreConfig.class.getName() + ".deleteStashes");
    private String container;
    private String prefix;
    @Deprecated
    private transient String region;
    @Deprecated
    private transient String credentialsId;
    private boolean usePathStyleUrl;
    private boolean useHttp;
    private boolean useTransferAcceleration;
    private boolean disableSessionToken;
    private String customEndpoint;
    private String customSigningRegion;
    private final boolean deleteArtifacts;
    private final boolean deleteStashes;

    public S3BlobStoreConfig() {
        this.load();
        if (Util.fixEmpty((String)this.region) != null || Util.fixEmpty((String)this.credentialsId) != null) {
            CredentialsAwsGlobalConfiguration.get().setRegion(this.region);
            CredentialsAwsGlobalConfiguration.get().setCredentialsId(this.credentialsId);
            this.region = null;
            this.credentialsId = null;
            this.save();
        }
        this.deleteArtifacts = DELETE_ARTIFACTS;
        this.deleteStashes = DELETE_STASHES;
    }

    public String getContainer() {
        return this.container;
    }

    @DataBoundSetter
    public void setContainer(String container) {
        this.container = container;
        this.checkValue(this.doCheckContainer(container));
        this.save();
    }

    @CheckForNull
    public String getPrefix() {
        return this.prefix;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = Util.fixEmptyAndTrim((String)prefix);
        this.checkValue(this.doCheckPrefix(prefix));
        this.save();
    }

    private void checkValue(@NonNull FormValidation formValidation) {
        if (formValidation.kind == FormValidation.Kind.ERROR) {
            throw new Failure(formValidation.getMessage());
        }
    }

    public boolean isDeleteArtifacts() {
        return this.deleteArtifacts;
    }

    public boolean isDeleteStashes() {
        return this.deleteStashes;
    }

    public boolean getUsePathStyleUrl() {
        return this.usePathStyleUrl;
    }

    @DataBoundSetter
    public void setUsePathStyleUrl(boolean usePathStyleUrl) {
        this.usePathStyleUrl = usePathStyleUrl;
        this.save();
    }

    public boolean getUseHttp() {
        return this.useHttp;
    }

    @DataBoundSetter
    public void setUseHttp(boolean useHttp) {
        this.checkValue(this.doCheckUseHttp(useHttp));
        this.useHttp = useHttp;
        this.save();
    }

    public boolean getUseTransferAcceleration() {
        return this.useTransferAcceleration;
    }

    @DataBoundSetter
    public void setUseTransferAcceleration(boolean useTransferAcceleration) {
        this.useTransferAcceleration = useTransferAcceleration;
        this.save();
    }

    public boolean getDisableSessionToken() {
        return this.disableSessionToken;
    }

    @DataBoundSetter
    public void setDisableSessionToken(boolean disableSessionToken) {
        this.disableSessionToken = disableSessionToken;
        this.save();
    }

    public String getCustomEndpoint() {
        return this.customEndpoint;
    }

    @DataBoundSetter
    public void setCustomEndpoint(String customEndpoint) {
        this.checkValue(this.doCheckCustomEndpoint(customEndpoint));
        this.customEndpoint = customEndpoint;
        this.save();
    }

    public String getResolvedCustomEndpoint() {
        if (!this.customEndpoint.isBlank()) {
            String protocol = this.getUseHttp() ? "http" : "https";
            return protocol + "://" + this.customEndpoint;
        }
        return null;
    }

    public String getCustomSigningRegion() {
        return this.customSigningRegion;
    }

    @DataBoundSetter
    public void setCustomSigningRegion(String customSigningRegion) {
        this.customSigningRegion = customSigningRegion;
        this.checkValue(this.doCheckCustomSigningRegion(this.customSigningRegion));
        this.save();
    }

    @NonNull
    public String getDisplayName() {
        return "Artifact Manager Amazon S3 Bucket";
    }

    @NonNull
    public static S3BlobStoreConfig get() {
        return (S3BlobStoreConfig)((Object)ExtensionList.lookupSingleton(S3BlobStoreConfig.class));
    }

    S3ClientBuilder getAmazonS3ClientBuilder() throws URISyntaxException {
        S3ClientBuilder ret = S3Client.builder();
        String resolvedCustomEndpoint = this.getResolvedCustomEndpoint();
        if (resolvedCustomEndpoint != null && !resolvedCustomEndpoint.isBlank()) {
            String resolvedCustomSigningRegion = this.customSigningRegion;
            if (resolvedCustomSigningRegion.isBlank()) {
                resolvedCustomSigningRegion = this.getRegion().id();
            }
            ret = (S3ClientBuilder)((S3ClientBuilder)ret.endpointOverride(new URI(resolvedCustomEndpoint))).region(Region.of((String)resolvedCustomSigningRegion));
        } else {
            ret = (S3ClientBuilder)ret.region(this.getRegion());
        }
        ret = (S3ClientBuilder)ret.accelerate(Boolean.valueOf(this.useTransferAcceleration));
        ret = (S3ClientBuilder)ret.forcePathStyle(Boolean.valueOf(this.getUsePathStyleUrl()));
        return ret;
    }

    @VisibleForTesting
    public S3ClientBuilder getAmazonS3ClientBuilderWithCredentials() throws IOException {
        try {
            return this.getAmazonS3ClientBuilderWithCredentials(this.getDisableSessionToken());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Region getRegion() {
        String regionStr = CredentialsAwsGlobalConfiguration.get().getRegion();
        if (regionStr == null) {
            try {
                return new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (SdkClientException e) {
                LOGGER.warning("There is no region configured for this S3 bucket and aws sdk couldn't discover one so using default: " + String.valueOf(Region.US_EAST_1));
                return Region.US_EAST_1;
            }
        }
        return Region.of((String)regionStr);
    }

    private S3ClientBuilder getAmazonS3ClientBuilderWithCredentials(boolean disableSessionToken) throws IOException, URISyntaxException {
        S3ClientBuilder builder = this.getAmazonS3ClientBuilder();
        if (disableSessionToken) {
            builder = (S3ClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)CredentialsAwsGlobalConfiguration.get().getCredentials());
        } else {
            AwsSessionCredentials awsSessionCredentials = CredentialsAwsGlobalConfiguration.get().sessionCredentials(this.getRegion().id(), CredentialsAwsGlobalConfiguration.get().getCredentialsId());
            if (awsSessionCredentials != null) {
                builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsSessionCredentials));
            } else {
                throw new IOException("No session AWS credentials found");
            }
        }
        builder = (S3ClientBuilder)builder.region(this.getRegion());
        return builder;
    }

    public FormValidation doCheckContainer(@QueryParameter String container) {
        FormValidation ret = FormValidation.ok();
        if (container.isBlank()) {
            ret = FormValidation.warning((String)"The container name cannot be empty");
        } else if (!bucketPattern.matcher(container).matches()) {
            ret = FormValidation.error((String)"The S3 Bucket name does not match S3 bucket rules");
        }
        return ret;
    }

    public FormValidation doCheckPrefix(@QueryParameter String prefix) {
        FormValidation ret = prefix.isBlank() ? FormValidation.ok((String)"Artifacts will be stored in the root folder of the S3 Bucket.") : (prefix.endsWith("/") ? FormValidation.ok() : FormValidation.error((String)"A prefix must end with a slash."));
        return ret;
    }

    public FormValidation doCheckCustomSigningRegion(@QueryParameter String customSigningRegion) {
        FormValidation ret = customSigningRegion != null && customSigningRegion.isBlank() && (this.customEndpoint == null || !this.customEndpoint.isBlank()) ? FormValidation.ok((String)"'us-east-1' will be used when a custom endpoint is configured and custom signing region is blank.") : FormValidation.ok();
        return ret;
    }

    public FormValidation doCheckCustomEndpoint(@QueryParameter String customEndpoint) {
        FormValidation ret = FormValidation.ok();
        if (!customEndpoint.isBlank() && !endPointPattern.matcher(customEndpoint).matches()) {
            ret = FormValidation.error((String)"Custom Endpoint may not be valid.");
        }
        return ret;
    }

    public FormValidation doCheckUseHttp(@QueryParameter boolean useHttp) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (FIPS140.useCompliantAlgorithms() && useHttp) {
            return FormValidation.error((String)"Cannot use HTTP in FIPS mode.");
        }
        return FormValidation.ok();
    }

    public Bucket createS3Bucket(String name) throws IOException {
        try {
            return this.createS3Bucket(name, this.getDisableSessionToken());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private Bucket createS3Bucket(String name, boolean disableSessionToken) throws IOException, URISyntaxException {
        S3ClientBuilder builder = this.getAmazonS3ClientBuilderWithCredentials(disableSessionToken);
        try (S3Client client = (S3Client)((S3ClientBuilder)builder.accelerate(Boolean.valueOf(false))).build();){
            CreateBucketResponse response = client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(name).build());
            if (response.sdkHttpResponse().isSuccessful()) {
                Bucket bucket = (Bucket)Bucket.builder().name(name).build();
                return bucket;
            }
            throw new IOException("Cannot create bucket with name:" + name + " response status : " + response.sdkHttpResponse().statusCode());
        }
    }

    @RequirePOST
    public FormValidation doCreateS3Bucket(@QueryParameter String container, @QueryParameter boolean disableSessionToken) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FormValidation ret = FormValidation.ok((String)"success");
        try {
            this.createS3Bucket(container, disableSessionToken);
        }
        catch (Throwable t) {
            String msg = this.processExceptionMessage(t);
            ret = FormValidation.error((String)(msg == null || msg.length() <= 200 ? msg : msg.substring(0, 197) + "..."));
        }
        return ret;
    }

    void checkGetBucketLocation(String container, boolean disableSessionToken) throws IOException, URISyntaxException {
        S3ClientBuilder builder = this.getAmazonS3ClientBuilderWithCredentials(disableSessionToken);
        try (S3Client client = (S3Client)builder.build();){
            client.getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(container).build());
        }
    }

    @RequirePOST
    public FormValidation doValidateS3BucketConfig(@QueryParameter String container, @QueryParameter String prefix, @QueryParameter boolean useHttp, @QueryParameter boolean useTransferAcceleration, @QueryParameter boolean usePathStyleUrl, @QueryParameter boolean disableSessionToken, @QueryParameter String customEndpoint, @QueryParameter String customSigningRegion) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (FIPS140.useCompliantAlgorithms() && useHttp) {
            return FormValidation.warning((String)"Validation failed as \"use Insecure Http\" flag is enabled while in FIPS mode");
        }
        FormValidation ret = FormValidation.ok((String)"success");
        S3BlobStoreTester provider = new S3BlobStoreTester(container, prefix, useHttp, useTransferAcceleration, usePathStyleUrl, disableSessionToken, customEndpoint, customSigningRegion);
        try {
            JCloudsVirtualFile jc = new JCloudsVirtualFile(provider, container, prefix.replaceFirst("/$", ""));
            jc.list();
        }
        catch (Throwable t) {
            String msg = this.processExceptionMessage(t);
            ret = FormValidation.error((Throwable)t, (String)(msg == null || msg.length() <= 200 ? msg : msg.substring(0, 197) + "..."));
        }
        try {
            ((S3BlobStore)provider).getConfiguration().checkGetBucketLocation(container, disableSessionToken);
        }
        catch (Throwable t) {
            ret = FormValidation.warning((Throwable)t, (String)"GetBucketLocation failed");
        }
        return ret;
    }

    static {
        String timeout = SystemProperties.getString((String)(S3BlobStoreConfig.class.getName() + "." + SdkSystemSetting.AWS_METADATA_SERVICE_TIMEOUT.property()), (String)"10");
        System.setProperty(SdkSystemSetting.AWS_METADATA_SERVICE_TIMEOUT.property(), timeout);
    }

    private static class S3BlobStoreTester
    extends S3BlobStore {
        private static final long serialVersionUID = -3645770416235883487L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="This transient field is only modified from the class constructor.")
        private transient S3BlobStoreConfig config = new S3BlobStoreConfig();

        S3BlobStoreTester(String container, String prefix, boolean useHttp, boolean useTransferAcceleration, boolean usePathStyleUrl, boolean disableSessionToken, String customEndpoint, String customSigningRegion) {
            this.config.setContainer(container);
            this.config.setPrefix(prefix);
            this.config.setCustomEndpoint(customEndpoint);
            this.config.setCustomSigningRegion(customSigningRegion);
            this.config.setUseHttp(useHttp);
            this.config.setUseTransferAcceleration(useTransferAcceleration);
            this.config.setUsePathStyleUrl(usePathStyleUrl);
            this.config.setDisableSessionToken(disableSessionToken);
        }

        @Override
        public S3BlobStoreConfig getConfiguration() {
            return this.config;
        }
    }
}

