/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifact_manager_jclouds;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import io.jenkins.plugins.artifact_manager_jclouds.BlobStoreProvider;
import io.jenkins.plugins.artifact_manager_jclouds.JCloudsVirtualFile;
import io.jenkins.plugins.artifact_manager_jclouds.TikaUtil;
import io.jenkins.plugins.httpclient.RobustHTTPClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.ArtifactManager;
import jenkins.util.VirtualFile;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStores;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class JCloudsArtifactManager
extends ArtifactManager
implements StashManager.StashAwareArtifactManager {
    private static final Logger LOGGER = Logger.getLogger(JCloudsArtifactManager.class.getName());
    static RobustHTTPClient client = new RobustHTTPClient();
    private final BlobStoreProvider provider;
    private transient String key;

    JCloudsArtifactManager(@NonNull Run<?, ?> build, BlobStoreProvider provider) {
        this.provider = provider;
        this.onLoad(build);
    }

    private Object readResolve() {
        if (this.provider == null) {
            throw new IllegalStateException("Missing provider field");
        }
        return this;
    }

    public void onLoad(@NonNull Run<?, ?> build) {
        this.key = String.format("%s/%s", build.getParent().getFullName(), build.getNumber());
    }

    private String getBlobPath(String path) {
        return this.getBlobPath(this.key, path);
    }

    private String getBlobPath(String key, String path) {
        return String.format("%s%s/%s", this.provider.getPrefix(), key, path);
    }

    public void archive(FilePath workspace, Launcher launcher, BuildListener listener, Map<String, String> artifacts) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "Archiving from {0}: {1}", new Object[]{workspace, artifacts});
        Map contentTypes = (Map)workspace.act((FilePath.FileCallable)new ContentTypeGuesser(new ArrayList<String>(artifacts.values()), (TaskListener)listener));
        LOGGER.fine(() -> "guessing content types: " + String.valueOf(contentTypes));
        BlobStore blobStore = this.getContext().getBlobStore();
        Map<String, URL> artifactUrls = this.provider.artifactUrls(artifacts, contentTypes, blobStore, this.key);
        workspace.act((FilePath.FileCallable)new UploadToBlobStorage(artifactUrls, contentTypes, (TaskListener)listener));
        listener.getLogger().printf("Uploaded %s artifact(s) to %s%n", artifactUrls.size(), this.provider.toURI(this.provider.getContainer(), this.getBlobPath("artifacts/")));
    }

    public boolean delete() throws IOException, InterruptedException {
        String blobPath = this.getBlobPath("");
        if (!this.provider.isDeleteArtifacts()) {
            LOGGER.log(Level.FINE, "Ignoring blob deletion: {0}", blobPath);
            return false;
        }
        return JCloudsVirtualFile.delete(this.provider, this.getContext().getBlobStore(), blobPath);
    }

    public VirtualFile root() {
        return new JCloudsVirtualFile(this.provider, this.provider.getContainer(), this.getBlobPath("artifacts"));
    }

    public void stash(String name, FilePath workspace, Launcher launcher, EnvVars env, TaskListener listener, String includes, String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        BlobStore blobStore = this.getContext().getBlobStore();
        String path = this.getBlobPath("stashes/" + name + ".tgz");
        Blob blob = blobStore.blobBuilder(path).build();
        blob.getMetadata().setContainer(this.provider.getContainer());
        blob.getMetadata().getContentMetadata().setContentType(null);
        URL url = this.provider.toExternalURL(blob, BlobStoreProvider.HttpMethod.PUT);
        FilePath tempDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempDir == null) {
            throw new AbortException("Could not make temporary directory in " + String.valueOf(workspace));
        }
        workspace.act((FilePath.FileCallable)new Stash(url, this.provider.toURI(this.provider.getContainer(), path), includes, excludes, useDefaultExcludes, allowEmpty, tempDir.getRemote(), listener));
    }

    public void unstash(String name, FilePath workspace, Launcher launcher, EnvVars env, TaskListener listener) throws IOException, InterruptedException {
        BlobStore blobStore = this.getContext().getBlobStore();
        String blobPath = this.getBlobPath("stashes/" + name + ".tgz");
        Blob blob = blobStore.getBlob(this.provider.getContainer(), blobPath);
        if (blob == null) {
            throw new AbortException(String.format("No such saved stash \u2018%s\u2019 found at %s/%s", name, this.provider.getContainer(), blobPath));
        }
        URL url = this.provider.toExternalURL(blob, BlobStoreProvider.HttpMethod.GET);
        workspace.act((FilePath.FileCallable)new Unstash(url, listener));
        listener.getLogger().printf("Unstashed file(s) from %s%n", this.provider.toURI(this.provider.getContainer(), blobPath));
    }

    public void clearAllStashes(TaskListener listener) throws IOException, InterruptedException {
        String stashPrefix = this.getBlobPath("stashes/");
        if (!this.provider.isDeleteStashes()) {
            LOGGER.log(Level.FINE, "Ignoring stash deletion: {0}", stashPrefix);
            return;
        }
        BlobStore blobStore = this.getContext().getBlobStore();
        int count = 0;
        try {
            for (StorageMetadata sm : BlobStores.listAll((BlobStore)blobStore, (String)this.provider.getContainer(), (ListContainerOptions)ListContainerOptions.Builder.prefix((String)stashPrefix).recursive())) {
                String path = sm.getName();
                assert (path.startsWith(stashPrefix));
                LOGGER.fine("deleting " + path);
                blobStore.removeBlob(this.provider.getContainer(), path);
                ++count;
            }
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        listener.getLogger().printf("Deleted %d stash(es) from %s%n", count, this.provider.toURI(this.provider.getContainer(), stashPrefix));
    }

    public void copyAllArtifactsAndStashes(Run<?, ?> to, TaskListener listener) throws IOException, InterruptedException {
        ArtifactManager am = to.pickArtifactManager();
        if (!(am instanceof JCloudsArtifactManager)) {
            throw new AbortException("Cannot copy artifacts and stashes to " + String.valueOf(to) + " using " + am.getClass().getName());
        }
        JCloudsArtifactManager dest = (JCloudsArtifactManager)am;
        String allPrefix = this.getBlobPath("");
        BlobStore blobStore = this.getContext().getBlobStore();
        int count = 0;
        try {
            for (StorageMetadata sm : BlobStores.listAll((BlobStore)blobStore, (String)this.provider.getContainer(), (ListContainerOptions)ListContainerOptions.Builder.prefix((String)allPrefix).recursive())) {
                String path = sm.getName();
                assert (path.startsWith(allPrefix));
                String destPath = this.getBlobPath(dest.key, path.substring(allPrefix.length()));
                LOGGER.fine("copying " + path + " to " + destPath);
                blobStore.copyBlob(this.provider.getContainer(), path, this.provider.getContainer(), destPath, CopyOptions.NONE);
                ++count;
            }
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        listener.getLogger().printf("Copied %d artifact(s)/stash(es) from %s to %s%n", count, this.provider.toURI(this.provider.getContainer(), allPrefix), this.provider.toURI(this.provider.getContainer(), dest.getBlobPath("")));
    }

    private BlobStoreContext getContext() throws IOException {
        return this.provider.getContext();
    }

    private static class ContentTypeGuesser
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private final Collection<String> relPaths;
        private final TaskListener listener;

        ContentTypeGuesser(Collection<String> relPaths, TaskListener listener) {
            this.relPaths = relPaths;
            this.listener = listener;
        }

        public Map<String, String> invoke(File f, VirtualChannel channel) {
            HashMap<String, String> contentTypes = new HashMap<String, String>();
            for (String relPath : this.relPaths) {
                File theFile = new File(f, relPath);
                try {
                    String contentType = Files.probeContentType(theFile.toPath());
                    if (contentType == null) {
                        contentType = URLConnection.guessContentTypeFromName(theFile.getName());
                    }
                    if (contentType == null) {
                        contentType = TikaUtil.detectByTika(theFile);
                    }
                    contentTypes.put(relPath, contentType);
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Unable to determine content type for file: " + String.valueOf(theFile)));
                    contentTypes.put(relPath, "application/octet-stream");
                }
            }
            return contentTypes;
        }
    }

    private static class UploadToBlobStorage
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final Map<String, URL> artifactUrls;
        private final Map<String, String> contentTypes;
        private final TaskListener listener;
        private final RobustHTTPClient client = client;

        UploadToBlobStorage(Map<String, URL> artifactUrls, Map<String, String> contentTypes, TaskListener listener) {
            this.artifactUrls = artifactUrls;
            this.contentTypes = contentTypes;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try {
                for (Map.Entry<String, URL> entry : this.artifactUrls.entrySet()) {
                    this.client.uploadFile(new File(f, entry.getKey()), this.contentTypes.get(entry.getKey()), entry.getValue(), this.listener);
                }
            }
            finally {
                this.listener.getLogger().flush();
            }
            return null;
        }
    }

    private static final class Stash
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final URL url;
        private final URI uri;
        private final String includes;
        private final String excludes;
        private final boolean useDefaultExcludes;
        private final boolean allowEmpty;
        private final String tempDir;
        private final TaskListener listener;
        private final RobustHTTPClient client = client;

        Stash(URL url, URI uri, String includes, String excludes, boolean useDefaultExcludes, boolean allowEmpty, String tempDir, TaskListener listener) throws IOException {
            this.url = url;
            this.uri = uri;
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
            this.allowEmpty = allowEmpty;
            this.tempDir = tempDir;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Path tempDirP = Paths.get(this.tempDir, new String[0]);
            Files.createDirectories(tempDirP, new FileAttribute[0]);
            Path tmp = Files.createTempFile(tempDirP, "stash", ".tgz", new FileAttribute[0]);
            try {
                int count;
                try (OutputStream os = Files.newOutputStream(tmp, new OpenOption[0]);){
                    count = new FilePath(f).archive(ArchiverFactory.TARGZ, os, (DirScanner)new DirScanner.Glob(Util.fixEmpty((String)this.includes) == null ? "**" : this.includes, this.excludes, this.useDefaultExcludes));
                }
                catch (InvalidPathException e) {
                    throw new IOException(e);
                }
                if (count == 0 && !this.allowEmpty) {
                    throw new AbortException("No files included in stash");
                }
                this.client.uploadFile(tmp.toFile(), this.url, this.listener);
                this.listener.getLogger().printf("Stashed %d file(s) to %s%n", count, this.uri);
                Void void_ = null;
                return void_;
            }
            finally {
                this.listener.getLogger().flush();
                Files.delete(tmp);
            }
        }
    }

    private static final class Unstash
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final URL url;
        private final TaskListener listener;
        private final RobustHTTPClient client = client;

        Unstash(URL url, TaskListener listener) throws IOException {
            this.url = url;
            this.listener = listener;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try {
                this.client.connect("download", "download " + RobustHTTPClient.sanitize((URL)this.url) + " into " + String.valueOf(f), c -> c.execute((HttpUriRequest)new HttpGet(this.url.toString())), response -> {
                    try (InputStream is = response.getEntity().getContent();){
                        new FilePath(f).untarFrom(is, FilePath.TarCompression.GZIP);
                    }
                }, this.listener);
            }
            finally {
                this.listener.getLogger().flush();
            }
            return null;
        }
    }
}

