/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifact_manager_jclouds;

import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.artifact_manager_jclouds.BlobStoreProvider;
import io.jenkins.plugins.artifact_manager_jclouds.JCloudsArtifactManager;
import jenkins.model.ArtifactManager;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.ArtifactManagerFactoryDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class JCloudsArtifactManagerFactory
extends ArtifactManagerFactory {
    private final BlobStoreProvider provider;

    @DataBoundConstructor
    public JCloudsArtifactManagerFactory(BlobStoreProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
    }

    private Object readResolve() {
        if (this.provider == null) {
            throw new IllegalStateException("Missing provider field");
        }
        return this;
    }

    public BlobStoreProvider getProvider() {
        return this.provider;
    }

    public ArtifactManager managerFor(Run<?, ?> build) {
        return new JCloudsArtifactManager(build, this.provider);
    }

    @Symbol(value={"jclouds"})
    @Extension
    public static final class DescriptorImpl
    extends ArtifactManagerFactoryDescriptor {
        public String getDisplayName() {
            return "Cloud Artifact Storage";
        }
    }
}

