/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifact_manager_jclouds;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import io.jenkins.plugins.artifact_manager_jclouds.BlobStoreProviderDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public abstract class BlobStoreProvider
extends AbstractDescribableImpl<BlobStoreProvider>
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = -861350249543443493L;

    @NonNull
    public abstract String getPrefix();

    @NonNull
    public abstract String getContainer();

    public abstract boolean isDeleteArtifacts();

    public abstract boolean isDeleteStashes();

    @NonNull
    public abstract BlobStoreContext getContext() throws IOException;

    @NonNull
    public abstract URI toURI(@NonNull String var1, @NonNull String var2);

    @NonNull
    public abstract URL toExternalURL(@NonNull Blob var1, @NonNull HttpMethod var2) throws IOException;

    public BlobStoreProviderDescriptor getDescriptor() {
        return (BlobStoreProviderDescriptor)super.getDescriptor();
    }

    public Map<String, URL> artifactUrls(Map<String, String> artifacts, Map<String, String> contentTypes, BlobStore blobStore, String key) throws IOException {
        HashMap<String, URL> artifactUrls = new HashMap<String, URL>();
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            String path = "artifacts/" + entry.getKey();
            String blobPath = this.getBlobPath(key, path);
            Blob blob = blobStore.blobBuilder(blobPath).build();
            blob.getMetadata().setContainer(this.getContainer());
            blob.getMetadata().getContentMetadata().setContentType(contentTypes.get(entry.getValue()));
            artifactUrls.put(entry.getValue(), this.toExternalURL(blob, HttpMethod.PUT));
        }
        return artifactUrls;
    }

    protected String getBlobPath(String key, String path) {
        return String.format("%s%s/%s", this.getPrefix(), key, path);
    }

    public static enum HttpMethod {
        GET,
        PUT;

    }
}

