/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.armorcode;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.AsyncPeriodicWork;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scheduler.CronTabList;
import hudson.util.DescribableList;
import io.jenkins.plugins.armorcode.ArmorCodeReleaseGateBuilder;
import io.jenkins.plugins.armorcode.config.ArmorCodeGlobalConfig;
import io.jenkins.plugins.armorcode.credentials.CredentialsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONObject;

@Extension
public class ArmorCodeJobDiscovery
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(ArmorCodeJobDiscovery.class.getName());
    private Calendar lastExecutionTime = null;

    public ArmorCodeJobDiscovery() {
        super("ArmorCode Job Discovery");
    }

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    private boolean shouldExecuteNow(String cronExpression) {
        try {
            Calendar now = Calendar.getInstance();
            Calendar currentMinute = (Calendar)now.clone();
            currentMinute.set(13, 0);
            currentMinute.set(14, 0);
            if (this.lastExecutionTime != null && this.lastExecutionTime.equals(currentMinute)) {
                LOGGER.fine("[ArmorCode] Already executed in this minute, skipping");
                return false;
            }
            CronTabList cronTabList = CronTabList.create((String)cronExpression);
            if (cronTabList.check(currentMinute)) {
                LOGGER.fine("[ArmorCode] Cron expression '" + cronExpression + "' matches current time " + String.format("%tF %<tT", currentMinute) + " - executing discovery");
                this.lastExecutionTime = currentMinute;
                return true;
            }
            LOGGER.fine("[ArmorCode] Cron expression '" + cronExpression + "' does not match current time " + String.format("%tF %<tT", currentMinute));
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error checking cron schedule: " + cronExpression, e);
            return false;
        }
    }

    protected void execute(TaskListener listener) {
        try {
            ArmorCodeGlobalConfig config = ArmorCodeGlobalConfig.get();
            if (config == null) {
                LOGGER.fine("[ArmorCode] Global config not yet loaded, skipping discovery");
                return;
            }
            if (!config.isMonitorBuilds()) {
                LOGGER.fine("[ArmorCode] Job discovery is disabled in configuration");
                return;
            }
            String cronExpression = config.getCronExpression();
            if (cronExpression == null || cronExpression.isBlank()) {
                cronExpression = "H H * * 0";
            }
            if (!this.shouldExecuteNow(cronExpression)) {
                return;
            }
            LOGGER.fine("[ArmorCode] Starting job discovery scan at " + String.valueOf(new Date()));
            listener.getLogger().println("[ArmorCode] Starting job discovery scan");
            String token = CredentialsUtils.getSystemToken();
            if (token == null) {
                LOGGER.warning("[ArmorCode] No ArmorCode token found - skipping job discovery");
                listener.getLogger().println("[ArmorCode] No ArmorCode token found - skipping job discovery");
                return;
            }
            List<JSONObject> jobsData = this.collectJobsData(config, listener);
            if (jobsData.isEmpty()) {
                LOGGER.fine("[ArmorCode] No matching jobs found during discovery");
                listener.getLogger().println("[ArmorCode] No matching jobs found during discovery");
                return;
            }
            LOGGER.fine("[ArmorCode] Collected " + jobsData.size() + " jobs for discovery");
            boolean success = this.sendJobsDataInBatches(config, token, jobsData, listener);
            if (success) {
                LOGGER.fine("[ArmorCode] Successfully sent " + jobsData.size() + " jobs to ArmorCode");
                listener.getLogger().println("[ArmorCode] Successfully sent " + jobsData.size() + " jobs to ArmorCode");
            } else {
                LOGGER.warning("[ArmorCode] Failed to send job discovery data");
                listener.getLogger().println("[ArmorCode] Failed to send job discovery data");
            }
        }
        catch (Exception e) {
            listener.error("[ArmorCode] Error during job discovery. See Jenkins system log for details.");
            LOGGER.log(Level.SEVERE, "[ArmorCode] Error during job discovery", e);
        }
    }

    private List<JSONObject> collectJobsData(ArmorCodeGlobalConfig config, TaskListener listener) throws IOException, InvocationTargetException, IllegalAccessException {
        ArrayList<JSONObject> jobsData = new ArrayList<JSONObject>();
        String includePattern = config.getIncludeJobsPattern();
        String excludePattern = config.getExcludeJobsPattern();
        for (Job job : Jenkins.get().getAllItems(Job.class)) {
            String jobName = job.getFullName();
            if (!this.shouldMonitorJob(jobName, includePattern, excludePattern)) continue;
            JSONObject jobData = new JSONObject();
            jobData.put("jobName", (Object)jobName);
            Run lastBuild = job.getLastBuild();
            if (lastBuild != null) {
                jobData.put("buildNumber", (Object)String.valueOf(lastBuild.getNumber()));
                jobData.put("lastBuildTimestamp", (Object)lastBuild.getTimeInMillis());
            } else {
                jobData.put("buildNumber", (Object)"0");
                jobData.put("lastBuildTimestamp", (Object)0);
            }
            jobData.put("buildTool", (Object)"JENKINS");
            String jobUrl = job.getAbsoluteUrl();
            if (jobUrl != null && !jobUrl.isEmpty()) {
                jobData.put("jobURL", (Object)jobUrl);
            } else {
                String jenkinsRootUrl = JenkinsLocationConfiguration.get().getUrl();
                if (jenkinsRootUrl != null && !jenkinsRootUrl.isEmpty()) {
                    jobData.put("jobURL", (Object)(jenkinsRootUrl + "job/" + jobName + "/"));
                } else {
                    LOGGER.warning("[ArmorCode] Could not determine Jenkins job URL. Please configure the Jenkins URL in the Jenkins global configuration.");
                    jobData.put("jobURL", (Object)"");
                }
            }
            Boolean isJobMapped = this.isUsingArmorCodePlugin(job);
            jobData.put("jobMapped", (Object)isJobMapped);
            jobsData.add(jobData);
        }
        return jobsData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUsingArmorCodePlugin(Job<?, ?> job) {
        block46: {
            block45: {
                block44: {
                    try {
                        Project project;
                        if (job instanceof Project) {
                            project = (Project)job;
                            for (Object builder : project.getBuildersList()) {
                                if (!(builder instanceof ArmorCodeReleaseGateBuilder)) continue;
                                return true;
                            }
                        }
                        if (!(job instanceof AbstractProject)) break block44;
                        project = (AbstractProject)job;
                        try {
                            Method getBuildersMethod = project.getClass().getMethod("getBuildersList", new Class[0]);
                            Iterator buildersList = getBuildersMethod.invoke((Object)project, new Object[0]);
                            if (buildersList instanceof DescribableList) {
                                for (Object builder : (DescribableList)buildersList) {
                                    if (!(builder instanceof ArmorCodeReleaseGateBuilder)) continue;
                                    return true;
                                }
                            }
                        }
                        catch (NoSuchMethodException getBuildersMethod) {}
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error while inspecting job " + job.getFullName(), e);
                    }
                }
                try {
                    Run lastBuild = job.getLastBuild();
                    if (lastBuild == null) break block45;
                    ParametersAction params = (ParametersAction)lastBuild.getAction(ParametersAction.class);
                    if (params != null) {
                        for (ParameterValue param : params.getParameters()) {
                            if (!param.getName().startsWith("ArmorCode.")) continue;
                            return true;
                        }
                    }
                    try {
                        FilePath markerFile = new FilePath(lastBuild.getRootDir()).child("armorcode-gate-used.txt");
                        if (markerFile.exists()) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error checking for marker file in " + job.getFullName(), e);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error checking build parameters for " + job.getFullName(), e);
                }
            }
            try {
                boolean isPipelineJob = job.getClass().getName().contains("org.jenkinsci.plugins.workflow.job.WorkflowJob");
                if (!isPipelineJob) break block46;
                try {
                    String configXml = job.getConfigFile().asString();
                    if (configXml.contains("armorcodeReleaseGate(")) return true;
                    if (configXml.contains("new ArmorCodeReleaseGateBuilder(")) return true;
                    if (configXml.contains("step $class: 'ArmorCodeReleaseGateBuilder'")) return true;
                    if (configXml.contains("ArmorCode.GateUsed")) return true;
                    if (configXml.matches("(?s).*\\bArmorCode\\b.*\\bReleaseGate\\b.*")) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error checking XML config for " + job.getFullName(), e);
                }
                try {
                    Run lastBuild = job.getLastBuild();
                    if (lastBuild == null) break block46;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(lastBuild.getLogInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.contains("=== Starting ArmorCode Release Gate Check ===") && !line.contains("=== ArmorCode Release Gate ===") && !line.matches(".*\\[INFO\\]\\s+ArmorCode check passed.*") && !line.matches(".*\\[BLOCK\\]\\s+SLA check.*")) continue;
                            boolean builder = true;
                            return builder;
                        }
                    }
                    for (Object action : lastBuild.getAllActions()) {
                        if (!action.getClass().getName().contains("ArmorCode")) continue;
                        return true;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error checking build logs for " + job.getFullName(), e);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error checking pipeline config for " + job.getFullName(), e);
            }
        }
        try {
            String configXml = job.getConfigFile().asString();
            if (configXml.contains("armorcode.ai/client/buildvalidation")) return true;
            if (configXml.contains("armorcode.com/client/buildvalidation")) return true;
            if (configXml.contains("curl") && configXml.contains("Authorization: Bearer")) {
                if (configXml.contains("armorcode.ai")) return true;
                if (configXml.contains("ArmorCode")) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error checking config for script-based integration", e);
        }
        try {
            ItemGroup parent = job.getParent();
            if (!parent.getClass().getName().contains("MultiBranchProject")) return false;
            Iterator iterator = parent.getAllItems(Job.class).iterator();
            block35: while (iterator.hasNext()) {
                Job siblingJob = (Job)iterator.next();
                if (siblingJob == job) continue;
                try {
                    Run siblingBuild = siblingJob.getLastBuild();
                    if (siblingBuild == null) continue;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(siblingBuild.getLogInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        do {
                            if ((line = reader.readLine()) == null) continue block35;
                        } while (!line.contains("ArmorCode") && !line.contains("armorcode") && !line.contains("armorcodeReleaseGate"));
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error checking sibling branch for " + job.getFullName(), e);
                }
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error checking parent job for " + job.getFullName(), e);
        }
        return false;
    }

    private boolean sendJobsDataInBatches(ArmorCodeGlobalConfig config, String token, List<JSONObject> allJobsData, TaskListener listener) {
        int BATCH_SIZE = 50;
        int totalJobs = allJobsData.size();
        int successCount = 0;
        int batchCount = (int)Math.ceil((double)totalJobs / 50.0);
        for (int i = 0; i < batchCount; ++i) {
            int startIndex = i * 50;
            int endIndex = Math.min(startIndex + 50, totalJobs);
            List<JSONObject> batchJobs = allJobsData.subList(startIndex, endIndex);
            boolean batchSuccess = this.sendBatch(config, token, batchJobs, listener);
            if (batchSuccess) {
                successCount += batchJobs.size();
            }
            if (i >= batchCount - 1) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        LOGGER.fine("[ArmorCode] Successfully sent " + successCount + " of " + totalJobs + " jobs to ArmorCode");
        return successCount == totalJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBatch(ArmorCodeGlobalConfig config, String token, List<JSONObject> batchJobs, TaskListener listener) {
        HttpURLConnection conn = null;
        try {
            JSONObject batchPayload = new JSONObject();
            batchPayload.put("jobsCount", (Object)batchJobs.size());
            batchPayload.put("jobs", batchJobs);
            String uri = config.getBaseUrl() + "/client/builds/jobs/discovery/monitoring";
            URL url = new URL(uri);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + token);
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            conn.setDoOutput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            try (OutputStream os = conn.getOutputStream();){
                os.write(batchPayload.toString().getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                String errorDetails = "";
                try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder errorResponse = new StringBuilder();
                    while ((line = errorReader.readLine()) != null) {
                        errorResponse.append(line);
                    }
                    errorDetails = errorResponse.toString();
                }
                catch (IOException ex) {
                    listener.error("[ArmorCode] Could not read error response: " + ex.getMessage());
                    LOGGER.log(Level.WARNING, "Could not read error response", ex);
                }
                LOGGER.log(Level.WARNING, "Batch send failed with HTTP " + responseCode + (String)(errorDetails.isEmpty() ? "" : ": " + errorDetails));
                boolean ex = false;
                return ex;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                LOGGER.fine("[ArmorCode] Batch sent successfully. Response: " + response.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            listener.error("[ArmorCode] Error sending batch: " + e.getMessage());
            LOGGER.log(Level.WARNING, "Error sending batch to ArmorCode", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private boolean shouldMonitorJob(String jobName, String includePattern, String excludePattern) {
        if (excludePattern != null && !excludePattern.isEmpty() && jobName.matches(excludePattern)) {
            return false;
        }
        return includePattern == null || includePattern.isEmpty() || jobName.matches(includePattern);
    }
}

