/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.scanner;

public enum Region {
    GLOBAL("global", "Global", "https://secure.appknox.com/"),
    UAE("uae", "UAE", "https://secure.uae.appknox.com/"),
    SAUDI("saudi", "Saudi", "https://sa.secure.appknox.com/");

    private final String value;
    private final String displayName;
    private final String baseUrl;

    private Region(String value, String displayName, String baseUrl) {
        this.value = value;
        this.displayName = displayName;
        this.baseUrl = baseUrl;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static Region getDefault() {
        return GLOBAL;
    }

    public static Region fromValue(String value) {
        if (value == null || value.isEmpty()) {
            return Region.getDefault();
        }
        for (Region region : Region.values()) {
            if (!region.value.equalsIgnoreCase(value)) continue;
            return region;
        }
        return Region.getDefault();
    }
}

