/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen;

import com.amazon.inspector.jenkins.amazoninspectorbuildstep.AmazonInspectorBuilder;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen.DownloaderCallable;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen.SbomgenUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.remoting.Future;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;

public class SbomgenDownloader {
    private static final String BASE_URL = "https://amazon-inspector-sbomgen.s3.amazonaws.com/latest/linux/%s/inspector-sbomgen.zip";

    public static String getBinary(FilePath workspace, EnvVars env, Launcher launcher) throws IOException, InterruptedException, ExecutionException {
        String url = SbomgenDownloader.getUrl(workspace, env, launcher);
        FilePath zipPath = SbomgenDownloader.downloadFile(url, workspace);
        return SbomgenDownloader.unzipFile(zipPath);
    }

    public static String getUrl(FilePath workspace, EnvVars env, Launcher launcher) throws IOException, InterruptedException {
        String osName = System.getProperty("os.name").toLowerCase();
        AmazonInspectorBuilder.logger.println("Detected OS Name: " + osName);
        if (!osName.contains("linux")) {
            throw new UnsupportedOperationException("Unsupported OS: " + osName);
        }
        String architecture = "amd64";
        String osArch = null;
        if (launcher != null) {
            try {
                HashMap<String, String> environment = new HashMap<String, String>();
                String output = SbomgenUtils.runCommand(new String[]{"uname", "-m"}, launcher, environment);
                if (output != null && !output.trim().isEmpty()) {
                    osArch = output.trim();
                    AmazonInspectorBuilder.logger.println("Detected OS Architecture (from agent): " + osArch);
                }
            }
            catch (Exception e) {
                AmazonInspectorBuilder.logger.println("Failed to detect architecture from agent: " + e.getMessage());
            }
        }
        if (osArch == null || osArch.trim().isEmpty()) {
            osArch = System.getProperty("os.arch").toLowerCase();
            AmazonInspectorBuilder.logger.println("Detected OS Architecture (fallback from master): " + osArch);
        }
        if ((osArch = osArch.toLowerCase().trim()).contains("arm64") || osArch.contains("aarch64")) {
            architecture = "arm64";
        } else if (!osArch.contains("amd64") && !osArch.contains("x86_64")) {
            throw new UnsupportedOperationException("Unsupported architecture: " + osArch);
        }
        return String.format(BASE_URL, architecture);
    }

    private static FilePath downloadFile(String url, FilePath workspace) throws IOException, InterruptedException {
        FilePath sbomgenZip = workspace.child("inspector-sbomgen.zip");
        sbomgenZip.copyFrom((InputStream)new BufferedInputStream(new URL(url).openStream()));
        return sbomgenZip;
    }

    @SuppressFBWarnings
    private static String unzipFile(FilePath zip) throws IOException, InterruptedException, ExecutionException {
        FilePath destination = zip.getParent().child(zip.getRemote().replace(".zip", ""));
        Future callable = zip.actAsync((FilePath.FileCallable)new DownloaderCallable(destination.getRemote()));
        return (String)callable.get();
    }
}

