/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components;

import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Advisory;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Affect;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Property;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Rating;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Reference;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Source;
import java.util.List;
import lombok.Generated;

public class Vulnerability {
    private String bomRef;
    private String id;
    private Source source;
    private List<Reference> references;
    private List<Rating> ratings;
    private List<Integer> cwes;
    private String description;
    private List<Advisory> advisories;
    private String created;
    private String modified;
    private String updated;
    private List<Affect> affects;
    private List<Property> properties;

    public Double getEpssScore() {
        if (this.ratings == null) {
            return null;
        }
        for (Rating rating : this.ratings) {
            if (rating.getSource() == null || !"EPSS".equalsIgnoreCase(rating.getSource().getName())) continue;
            return rating.getScore();
        }
        return null;
    }

    @Generated
    Vulnerability(String bomRef, String id, Source source, List<Reference> references, List<Rating> ratings, List<Integer> cwes, String description, List<Advisory> advisories, String created, String modified, String updated, List<Affect> affects, List<Property> properties) {
        this.bomRef = bomRef;
        this.id = id;
        this.source = source;
        this.references = references;
        this.ratings = ratings;
        this.cwes = cwes;
        this.description = description;
        this.advisories = advisories;
        this.created = created;
        this.modified = modified;
        this.updated = updated;
        this.affects = affects;
        this.properties = properties;
    }

    @Generated
    public static VulnerabilityBuilder builder() {
        return new VulnerabilityBuilder();
    }

    @Generated
    public String getBomRef() {
        return this.bomRef;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Source getSource() {
        return this.source;
    }

    @Generated
    public List<Reference> getReferences() {
        return this.references;
    }

    @Generated
    public List<Rating> getRatings() {
        return this.ratings;
    }

    @Generated
    public List<Integer> getCwes() {
        return this.cwes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<Advisory> getAdvisories() {
        return this.advisories;
    }

    @Generated
    public String getCreated() {
        return this.created;
    }

    @Generated
    public String getModified() {
        return this.modified;
    }

    @Generated
    public String getUpdated() {
        return this.updated;
    }

    @Generated
    public List<Affect> getAffects() {
        return this.affects;
    }

    @Generated
    public List<Property> getProperties() {
        return this.properties;
    }

    @Generated
    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSource(Source source) {
        this.source = source;
    }

    @Generated
    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    @Generated
    public void setRatings(List<Rating> ratings) {
        this.ratings = ratings;
    }

    @Generated
    public void setCwes(List<Integer> cwes) {
        this.cwes = cwes;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setAdvisories(List<Advisory> advisories) {
        this.advisories = advisories;
    }

    @Generated
    public void setCreated(String created) {
        this.created = created;
    }

    @Generated
    public void setModified(String modified) {
        this.modified = modified;
    }

    @Generated
    public void setUpdated(String updated) {
        this.updated = updated;
    }

    @Generated
    public void setAffects(List<Affect> affects) {
        this.affects = affects;
    }

    @Generated
    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Generated
    public static class VulnerabilityBuilder {
        @Generated
        private String bomRef;
        @Generated
        private String id;
        @Generated
        private Source source;
        @Generated
        private List<Reference> references;
        @Generated
        private List<Rating> ratings;
        @Generated
        private List<Integer> cwes;
        @Generated
        private String description;
        @Generated
        private List<Advisory> advisories;
        @Generated
        private String created;
        @Generated
        private String modified;
        @Generated
        private String updated;
        @Generated
        private List<Affect> affects;
        @Generated
        private List<Property> properties;

        @Generated
        VulnerabilityBuilder() {
        }

        @Generated
        public VulnerabilityBuilder bomRef(String bomRef) {
            this.bomRef = bomRef;
            return this;
        }

        @Generated
        public VulnerabilityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public VulnerabilityBuilder source(Source source) {
            this.source = source;
            return this;
        }

        @Generated
        public VulnerabilityBuilder references(List<Reference> references) {
            this.references = references;
            return this;
        }

        @Generated
        public VulnerabilityBuilder ratings(List<Rating> ratings) {
            this.ratings = ratings;
            return this;
        }

        @Generated
        public VulnerabilityBuilder cwes(List<Integer> cwes) {
            this.cwes = cwes;
            return this;
        }

        @Generated
        public VulnerabilityBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public VulnerabilityBuilder advisories(List<Advisory> advisories) {
            this.advisories = advisories;
            return this;
        }

        @Generated
        public VulnerabilityBuilder created(String created) {
            this.created = created;
            return this;
        }

        @Generated
        public VulnerabilityBuilder modified(String modified) {
            this.modified = modified;
            return this;
        }

        @Generated
        public VulnerabilityBuilder updated(String updated) {
            this.updated = updated;
            return this;
        }

        @Generated
        public VulnerabilityBuilder affects(List<Affect> affects) {
            this.affects = affects;
            return this;
        }

        @Generated
        public VulnerabilityBuilder properties(List<Property> properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public Vulnerability build() {
            return new Vulnerability(this.bomRef, this.id, this.source, this.references, this.ratings, this.cwes, this.description, this.advisories, this.created, this.modified, this.updated, this.affects, this.properties);
        }

        @Generated
        public String toString() {
            return "Vulnerability.VulnerabilityBuilder(bomRef=" + this.bomRef + ", id=" + this.id + ", source=" + String.valueOf(this.source) + ", references=" + String.valueOf(this.references) + ", ratings=" + String.valueOf(this.ratings) + ", cwes=" + String.valueOf(this.cwes) + ", description=" + this.description + ", advisories=" + String.valueOf(this.advisories) + ", created=" + this.created + ", modified=" + this.modified + ", updated=" + this.updated + ", affects=" + String.valueOf(this.affects) + ", properties=" + String.valueOf(this.properties) + ")";
        }
    }
}

