/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.akeyless.client.model.Auth;
import io.jenkins.plugins.akeyless.credentials.AbstractAkeylessBaseStandardCredentials;
import io.jenkins.plugins.akeyless.credentials.AkeylessCredential;
import io.jenkins.plugins.akeyless.credentials.CredentialsPayload;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AccessKeyCredentialsImpl
extends AbstractAkeylessBaseStandardCredentials
implements AkeylessCredential {
    private Secret accessKey;
    @NonNull
    private String accessId = "";

    @DataBoundConstructor
    public AccessKeyCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description) {
        super(scope, id, description);
    }

    public Secret getAccessKey() {
        return this.accessKey;
    }

    @DataBoundSetter
    public void setAccessKey(Secret accessKey) {
        this.accessKey = accessKey;
    }

    @NonNull
    public String getAccessId() {
        return this.accessId;
    }

    @DataBoundSetter
    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public CredentialsScope getScope() {
        return null;
    }

    public Auth getAuth() {
        Auth auth = new Auth();
        auth.setAccessType("api_key");
        auth.setAccessKey(this.accessKey.getPlainText());
        auth.setAccessId(this.accessId);
        return auth;
    }

    @Override
    public CredentialsPayload getCredentialsPayload() {
        CredentialsPayload payload = new CredentialsPayload();
        payload.setAuth(this.getAuth());
        return payload;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Akeyless API Key";
        }
    }
}

