/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceConfiguration;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.slaves.AbstractCloudSlave;
import jenkins.model.NodeListener;

@Extension
public class MaintenanceNodeListener
extends NodeListener {
    MaintenanceHelper helper = MaintenanceHelper.getInstance();

    protected void onCreated(@NonNull Node node) {
        if (node instanceof Slave && !(node instanceof AbstractCloudSlave)) {
            this.helper.createAgent(node.getNodeName());
            if (MaintenanceConfiguration.getInstance().isInjectRetentionStrategy()) {
                this.helper.injectRetentionStrategy(node.toComputer());
            }
        }
    }

    protected void onDeleted(@NonNull Node node) {
        if (node instanceof Slave) {
            this.helper.deleteAgent(node.getNodeName());
        }
    }

    protected void onUpdated(@NonNull Node oldNode, @NonNull Node newNode) {
        if (newNode instanceof Slave && !(newNode instanceof AbstractCloudSlave)) {
            if (!oldNode.getNodeName().equals(newNode.getNodeName())) {
                this.helper.renameAgent(oldNode.getNodeName(), newNode.getNodeName());
            }
            if (MaintenanceConfiguration.getInstance().isInjectRetentionStrategy()) {
                this.helper.injectRetentionStrategy(newNode.toComputer());
            }
        }
    }
}

