/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.AgentMaintenanceRetentionStrategy;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceDefinitions;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceWindow;
import com.sap.prd.jenkins.plugins.agent_maintenance.Messages;
import com.sap.prd.jenkins.plugins.agent_maintenance.RecurringMaintenanceWindow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.security.Permission;
import hudson.slaves.SlaveComputer;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

public class MaintenanceAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MaintenanceAction.class.getName());
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="called by Jelly")
    public static final Permission[] CONFIGURE_AND_DISCONNECT = new Permission[]{Computer.DISCONNECT, Computer.CONFIGURE};
    private final SlaveComputer computer;

    public MaintenanceAction(SlaveComputer computer) {
        this.computer = computer;
    }

    public Computer getComputer() {
        return this.computer;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isVisible() {
        return (this.computer.hasPermission(Computer.DISCONNECT) || this.computer.hasPermission(Computer.CONFIGURE) || this.computer.hasPermission(Computer.EXTENDED_READ)) && this.computer.getNode() != null;
    }

    public String getIconFileName() {
        if (this.isVisible()) {
            return "symbol-build-outline plugin-ionicons-api";
        }
        return null;
    }

    public String getDisplayName() {
        if (this.isVisible()) {
            if (this.computer.hasPermission(Computer.DISCONNECT) || this.computer.hasPermission(Computer.CONFIGURE)) {
                return Messages.MaintenanceAction_maintenanceWindows();
            }
            return Messages.MaintenanceAction_view();
        }
        return null;
    }

    public String getUrlName() {
        if (this.isVisible()) {
            return "maintenanceWindows";
        }
        return null;
    }

    public Class<MaintenanceWindow> getMaintenanceWindowClass() {
        return MaintenanceWindow.class;
    }

    public Class<RecurringMaintenanceWindow> getRecurringMaintenanceWindowClass() {
        return RecurringMaintenanceWindow.class;
    }

    public boolean isEnabled() {
        return this.computer.getRetentionStrategy() instanceof AgentMaintenanceRetentionStrategy;
    }

    public static String getDefaultStartTime() {
        LocalDateTime now = LocalDateTime.now();
        return MaintenanceWindow.DATE_FORMATTER.format(now);
    }

    public static String getDefaultEndTime() {
        LocalDateTime now = LocalDateTime.now();
        now = now.plusDays(1L);
        return MaintenanceWindow.DATE_FORMATTER.format(now);
    }

    public boolean hasMaintenanceWindows() {
        try {
            return MaintenanceHelper.getInstance().hasMaintenanceWindows(this.computer.getName());
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean hasActiveMaintenanceWindows() {
        try {
            return MaintenanceHelper.getInstance().hasActiveMaintenanceWindows(this.computer.getName());
        }
        catch (IOException e) {
            return false;
        }
    }

    public SortedSet<MaintenanceWindow> getMaintenanceWindows() {
        try {
            return Collections.unmodifiableSortedSet(MaintenanceHelper.getInstance().getMaintenanceWindows(this.computer.getName()));
        }
        catch (IOException e) {
            return Collections.emptySortedSet();
        }
    }

    public Set<RecurringMaintenanceWindow> getRecurringMaintenanceWindows() {
        try {
            return Collections.unmodifiableSet(MaintenanceHelper.getInstance().getRecurringMaintenanceWindows(this.computer.getName()));
        }
        catch (IOException e) {
            return Collections.emptySortedSet();
        }
    }

    @POST
    public HttpResponse doAdd(StaplerRequest2 req) throws IOException, ServletException {
        this.computer.checkAnyPermission(CONFIGURE_AND_DISCONNECT);
        JSONObject src = req.getSubmittedForm();
        MaintenanceWindow mw = (MaintenanceWindow)req.bindJSON(MaintenanceWindow.class, src);
        MaintenanceHelper.getInstance().addMaintenanceWindow(this.computer.getName(), mw);
        return FormApply.success((String)".");
    }

    @POST
    public void doAddRecurring(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.computer.checkAnyPermission(CONFIGURE_AND_DISCONNECT);
        JSONObject src = req.getSubmittedForm();
        RecurringMaintenanceWindow rmw = (RecurringMaintenanceWindow)((Object)req.bindJSON(RecurringMaintenanceWindow.class, src));
        MaintenanceHelper.getInstance().addRecurringMaintenanceWindow(this.computer.getName(), rmw);
        rsp.sendRedirect(".");
    }

    @JavaScriptMethod
    public String[] deleteMultiple(String[] ids) {
        this.computer.checkAnyPermission(CONFIGURE_AND_DISCONNECT);
        ArrayList<String> deletedList = new ArrayList<String>();
        for (String id : ids) {
            try {
                MaintenanceHelper.getInstance().deleteMaintenanceWindow(this.computer.getName(), id);
                deletedList.add(id);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error while deleting maintenance window", e);
            }
        }
        return deletedList.toArray(new String[0]);
    }

    @JavaScriptMethod
    public Map<String, Boolean> getMaintenanceStatus() {
        HashMap<String, Boolean> statusList = new HashMap<String, Boolean>();
        if (this.computer.hasAnyPermission(new Permission[]{Computer.DISCONNECT, Computer.CONFIGURE, Computer.EXTENDED_READ})) {
            try {
                for (MaintenanceWindow mw : MaintenanceHelper.getInstance().getMaintenanceWindows(this.computer.getName())) {
                    if (mw.isMaintenanceOver()) continue;
                    statusList.put(mw.getId(), mw.isMaintenanceScheduled());
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Failed to read maintenance windows", ioe);
            }
        }
        return statusList;
    }

    @JavaScriptMethod
    public String[] deleteMultipleRecurring(String[] ids) {
        this.computer.checkAnyPermission(CONFIGURE_AND_DISCONNECT);
        ArrayList<String> deletedList = new ArrayList<String>();
        for (String id : ids) {
            try {
                MaintenanceHelper.getInstance().deleteRecurringMaintenanceWindow(this.computer.getName(), id);
                deletedList.add(id);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error while deleting maintenance window", e);
            }
        }
        return deletedList.toArray(new String[0]);
    }

    @JavaScriptMethod
    public boolean deleteMaintenance(String id) {
        if (this.computer.hasAnyPermission(CONFIGURE_AND_DISCONNECT)) {
            if (Util.fixEmptyAndTrim((String)id) == null) {
                return false;
            }
            try {
                MaintenanceHelper.getInstance().deleteMaintenanceWindow(this.computer.getName(), id);
                return true;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Failed to delete maintenance window.", ioe);
                return false;
            }
        }
        return false;
    }

    @JavaScriptMethod
    public boolean deleteRecurringMaintenance(String id) {
        if (this.computer.hasAnyPermission(CONFIGURE_AND_DISCONNECT)) {
            if (Util.fixEmptyAndTrim((String)id) == null) {
                return false;
            }
            try {
                MaintenanceHelper.getInstance().deleteRecurringMaintenanceWindow(this.computer.getName(), id);
                return true;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Failed to delete recurring maintenance window.", ioe);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public synchronized HttpResponse doConfigSubmit(StaplerRequest2 req) throws IOException, ServletException {
        MaintenanceDefinitions md;
        this.computer.checkPermission(Computer.CONFIGURE);
        JSONObject src = req.getSubmittedForm();
        List newTargets = req.bindJSONToList(MaintenanceWindow.class, src.get("maintenanceWindows"));
        List newRecurringTargets = req.bindJSONToList(RecurringMaintenanceWindow.class, src.get("recurringMaintenanceWindows"));
        MaintenanceDefinitions maintenanceDefinitions = md = MaintenanceHelper.getInstance().getMaintenanceDefinitions(this.computer.getName());
        synchronized (maintenanceDefinitions) {
            SortedSet<MaintenanceWindow> scheduled = md.getScheduled();
            Set<RecurringMaintenanceWindow> recurring = md.getRecurring();
            scheduled.clear();
            scheduled.addAll(newTargets);
            recurring.clear();
            recurring.addAll(newRecurringTargets);
            MaintenanceHelper.getInstance().saveMaintenanceWindows(this.computer.getName(), md);
        }
        return FormApply.success((String)".");
    }

    @POST
    public void doEnable(StaplerResponse2 rsp) throws IOException {
        this.computer.checkPermission(Computer.CONFIGURE);
        MaintenanceHelper.getInstance().injectRetentionStrategy((Computer)this.computer);
        rsp.sendRedirect(".");
    }

    @POST
    public void doDisable(StaplerResponse2 rsp) throws IOException {
        this.computer.checkPermission(Computer.CONFIGURE);
        MaintenanceHelper.getInstance().removeRetentionStrategy((Computer)this.computer);
        rsp.sendRedirect(".");
    }
}

