/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.AgentMaintenanceRetentionStrategy;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceAction;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceWindow;
import com.sap.prd.jenkins.plugins.agent_maintenance.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.ManagementLink;
import hudson.model.Node;
import hudson.model.labels.LabelExpression;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.management.Badge;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

@Extension
public class MaintenanceLink
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(MaintenanceLink.class.getName());
    private transient Throwable error;

    public String getDescription() {
        return Messages.MaintenanceLink_description();
    }

    public String getDisplayName() {
        return Messages.MaintenanceLink_displayName();
    }

    public String getIconFileName() {
        return "symbol-maintenance plugin-agent-maintenance";
    }

    public String getUrlName() {
        return "agent-maintenances";
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    public List<MaintenanceAction> getAgents() {
        ArrayList<MaintenanceAction> agentList = new ArrayList<MaintenanceAction>();
        for (Node node : Jenkins.get().getNodes()) {
            MaintenanceAction action;
            Computer computer = node.toComputer();
            if (!(computer instanceof SlaveComputer) || !(action = new MaintenanceAction((SlaveComputer)computer)).hasMaintenanceWindows()) continue;
            agentList.add(action);
        }
        return agentList;
    }

    private void setError(Throwable error) {
        this.error = error;
    }

    public String getError() {
        StringWriter message = new StringWriter();
        this.error.printStackTrace(new PrintWriter(message));
        this.error = null;
        return message.toString();
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Badge getBadge() {
        int active = 0;
        int total = 0;
        List<MaintenanceAction> mwList = this.getAgents();
        for (MaintenanceAction ma : mwList) {
            ++total;
            if (!ma.hasActiveMaintenanceWindows()) continue;
            ++active;
        }
        if (total == 0) {
            return null;
        }
        String text = active + "/" + total;
        String tooltip = active + this.getVerb(active) + " an active maintenance window.\n" + total + this.getVerb(total) + " defined maintenance windows.";
        Badge.Severity severity = Badge.Severity.INFO;
        if (active > 0) {
            severity = Badge.Severity.WARNING;
        }
        return new Badge(text, tooltip, severity);
    }

    private String getVerb(int count) {
        if (count == 1) {
            return " agent has";
        }
        return " agents have";
    }

    @JavaScriptMethod
    public boolean deleteMaintenance(String id, String computerName) {
        if (this.hasPermission(computerName)) {
            try {
                MaintenanceHelper.getInstance().deleteMaintenanceWindow(computerName, id);
                return true;
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error while deleting maintenance window", e);
                return false;
            }
        }
        return false;
    }

    @JavaScriptMethod
    public String[] deleteMultiple(JSONObject json) {
        Map mwList = (Map)JSONObject.toBean((JSONObject)json, Map.class);
        ArrayList<String> deletedList = new ArrayList<String>();
        for (Map.Entry entry : mwList.entrySet()) {
            String computerName = (String)entry.getValue();
            if (!this.hasPermission(computerName)) continue;
            String id = (String)entry.getKey();
            try {
                MaintenanceHelper.getInstance().deleteMaintenanceWindow(computerName, id);
                deletedList.add(id);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error while deleting maintenance window", e);
            }
        }
        return deletedList.toArray(new String[0]);
    }

    @JavaScriptMethod
    public Map<String, Boolean> getMaintenanceStatus() {
        HashMap<String, Boolean> statusList = new HashMap<String, Boolean>();
        for (MaintenanceAction action : this.getAgents()) {
            Computer computer = action.getComputer();
            if (!computer.hasAnyPermission(new Permission[]{Computer.DISCONNECT, Computer.CONFIGURE, Computer.EXTENDED_READ})) continue;
            try {
                for (MaintenanceWindow mw : MaintenanceHelper.getInstance().getMaintenanceWindows(computer.getName())) {
                    if (mw.isMaintenanceOver()) continue;
                    statusList.put(mw.getId(), mw.isMaintenanceScheduled());
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Failed to read maintenance windows", ioe);
            }
        }
        return statusList;
    }

    private boolean hasPermission(String computerName) {
        Computer c = Jenkins.get().getComputer(computerName);
        if (c != null) {
            return c.hasAnyPermission(MaintenanceAction.CONFIGURE_AND_DISCONNECT);
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckLabel(@QueryParameter String value) {
        return LabelExpression.validate((String)value);
    }

    @Restricted(value={NoExternalUse.class})
    public AutoCompletionCandidates doAutoCompleteLabel(@QueryParameter String value) {
        return LabelExpression.autoComplete((String)value);
    }

    @POST
    public void doAdd(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        JSONObject src;
        String labelString;
        Jenkins j = Jenkins.get();
        Label label = j.getLabel(labelString = (src = req.getSubmittedForm()).optString("label"));
        if (label != null) {
            Set nodes = label.getNodes();
            MaintenanceWindow mw = (MaintenanceWindow)req.bindJSON(MaintenanceWindow.class, src);
            LOGGER.log(Level.FINER, "Adding maintenance windows {0}", mw);
            LOGGER.log(Level.FINER, "Adding maintenance windows for agents: {0}", nodes);
            nodes.stream().filter(n -> n.toComputer() instanceof SlaveComputer && !(n.toComputer() instanceof AbstractCloudComputer) && Objects.requireNonNull(n.toComputer()).getRetentionStrategy() instanceof AgentMaintenanceRetentionStrategy && n.hasAnyPermission(MaintenanceAction.CONFIGURE_AND_DISCONNECT)).forEach(n -> {
                try {
                    SlaveComputer computer = (SlaveComputer)n.toComputer();
                    MaintenanceWindow maintenanceWindow = (MaintenanceWindow)req.bindJSON(MaintenanceWindow.class, src);
                    MaintenanceHelper.getInstance().addMaintenanceWindow(computer.getName(), maintenanceWindow);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error while adding maintenance window", e);
                    this.setError(e);
                }
            });
        }
        rsp.sendRedirect(".");
    }

    public Class<MaintenanceWindow> getMaintenanceWindowClass() {
        return MaintenanceWindow.class;
    }
}

