/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceWindow;
import hudson.slaves.OfflineCause;

public class MaintenanceOfflineCause
extends OfflineCause {
    private MaintenanceWindow maintenanceWindow;
    private final String computerName;

    public MaintenanceOfflineCause(MaintenanceWindow maintenanceWindow, String computerName) {
        this.maintenanceWindow = maintenanceWindow;
        this.computerName = computerName;
    }

    private void updateMaintenanceWindow() {
        MaintenanceWindow newMaintenanceWindow = MaintenanceHelper.getInstance().getMaintenanceWindow(this.computerName, this.maintenanceWindow.getId());
        if (newMaintenanceWindow != null) {
            this.maintenanceWindow = newMaintenanceWindow;
        }
    }

    public String getStartTime() {
        this.updateMaintenanceWindow();
        return this.maintenanceWindow.getStartTime();
    }

    public String getEndTime() {
        this.updateMaintenanceWindow();
        return this.maintenanceWindow.getEndTime();
    }

    public String getReason() {
        this.updateMaintenanceWindow();
        return this.maintenanceWindow.getReason();
    }

    public boolean isTakeOnline() {
        return this.maintenanceWindow.isTakeOnline();
    }

    public String toString() {
        return this.getReason();
    }
}

