/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.AgentMaintenanceRetentionStrategy;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceDefinitions;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceWindow;
import com.sap.prd.jenkins.plugins.agent_maintenance.RecurringMaintenanceWindow;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.XmlFile;
import hudson.model.Computer;
import hudson.model.Slave;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class MaintenanceHelper {
    private static final Logger LOGGER = Logger.getLogger(MaintenanceHelper.class.getName());
    private static final MaintenanceHelper INSTANCE = new MaintenanceHelper();
    private final Map<String, MaintenanceDefinitions> cache = new ConcurrentHashMap<String, MaintenanceDefinitions>();

    private MaintenanceHelper() {
    }

    public static String getUuid(String id) {
        try {
            UUID uuid = UUID.fromString(id);
            return uuid.toString();
        }
        catch (IllegalArgumentException iae) {
            return UUID.randomUUID().toString();
        }
    }

    private boolean isValidUuid(String id) {
        try {
            UUID.fromString(id);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean isValidComputerName(String computerName) throws IOException {
        Jenkins jenkins = Jenkins.get();
        Computer computer = jenkins.getComputer(computerName);
        return computer != null;
    }

    private String getSafeComputerName(String computerName) {
        Jenkins jenkins = Jenkins.get();
        Computer computer = jenkins.getComputer(computerName);
        return computer != null ? computerName : "unknown";
    }

    public boolean hasMaintenanceWindows(String computerName) throws IOException {
        return this.cache.containsKey(computerName) && !this.getMaintenanceWindows(computerName).isEmpty();
    }

    public boolean hasActiveMaintenanceWindows(String computerName) throws IOException {
        SortedSet<MaintenanceWindow> maintenanceList;
        if (!this.cache.containsKey(computerName)) {
            return false;
        }
        try {
            maintenanceList = this.getMaintenanceWindows(computerName);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read maintenance window list for {0}", computerName);
            return false;
        }
        return maintenanceList.stream().anyMatch(MaintenanceWindow::isMaintenanceScheduled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMaintenanceWindow(String computerName, MaintenanceWindow mw) throws IOException {
        MaintenanceDefinitions md;
        LOGGER.log(Level.FINE, "Adding maintenance window for {0}: {1}", new Object[]{this.getSafeComputerName(computerName), mw.getId()});
        MaintenanceDefinitions maintenanceDefinitions = md = this.getMaintenanceDefinitions(computerName);
        synchronized (maintenanceDefinitions) {
            md.getScheduled().add(mw);
            this.saveMaintenanceWindows(computerName, md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecurringMaintenanceWindow(String computerName, RecurringMaintenanceWindow mw) throws IOException {
        MaintenanceDefinitions md;
        LOGGER.log(Level.FINE, "Adding maintenance window for {0}: {1}", new Object[]{this.getSafeComputerName(computerName), mw.getId()});
        MaintenanceDefinitions maintenanceDefinitions = md = this.getMaintenanceDefinitions(computerName);
        synchronized (maintenanceDefinitions) {
            md.getRecurring().add(mw);
            this.saveMaintenanceWindows(computerName, md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMaintenanceWindow(String computerName, String id) throws IOException {
        if (this.isValidUuid(id) && this.isValidComputerName(computerName)) {
            MaintenanceDefinitions md;
            LOGGER.log(Level.FINE, "Deleting maintenance window for {0}: {1}", new Object[]{this.getSafeComputerName(computerName), id});
            MaintenanceDefinitions maintenanceDefinitions = md = this.getMaintenanceDefinitions(computerName);
            synchronized (maintenanceDefinitions) {
                md.getScheduled().removeIf(mw -> Objects.equals(id, mw.getId()));
                this.saveMaintenanceWindows(computerName, md);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecurringMaintenanceWindow(String computerName, String id) throws IOException {
        if (this.isValidUuid(id) && this.isValidComputerName(computerName)) {
            MaintenanceDefinitions md;
            LOGGER.log(Level.FINE, "Deleting maintenance window for {0}: {1}", new Object[]{this.getSafeComputerName(computerName), id});
            MaintenanceDefinitions maintenanceDefinitions = md = this.getMaintenanceDefinitions(computerName);
            synchronized (maintenanceDefinitions) {
                md.getRecurring().removeIf(mw -> Objects.equals(id, mw.getId()));
                this.saveMaintenanceWindows(computerName, md);
            }
        }
    }

    @NonNull
    public SortedSet<MaintenanceWindow> getMaintenanceWindows(String computerName) throws IOException {
        LOGGER.log(Level.FINEST, "Loading maintenance list for {0}", this.getSafeComputerName(computerName));
        return this.getMaintenanceDefinitions(computerName).getScheduled();
    }

    public Set<RecurringMaintenanceWindow> getRecurringMaintenanceWindows(String computerName) throws IOException {
        LOGGER.log(Level.FINEST, "Loading recurring maintenance definitions for {0}", this.getSafeComputerName(computerName));
        return this.getMaintenanceDefinitions(computerName).getRecurring();
    }

    public MaintenanceDefinitions getMaintenanceDefinitions(String computerName) throws IOException {
        LOGGER.log(Level.FINEST, "Loading maintenance list for {0}", this.getSafeComputerName(computerName));
        if (Jenkins.get().getComputer(computerName) == null) {
            return new MaintenanceDefinitions(new TreeSet<MaintenanceWindow>(), new HashSet<RecurringMaintenanceWindow>());
        }
        MaintenanceDefinitions md = this.cache.get(computerName);
        if (md == null) {
            XmlFile xmlMaintenanceFile = this.getMaintenanceWindowsFile(computerName);
            if (xmlMaintenanceFile.exists()) {
                LOGGER.log(Level.FINER, "Loading maintenance list from file for {0}", this.getSafeComputerName(computerName));
                try {
                    md = (MaintenanceDefinitions)xmlMaintenanceFile.read();
                    this.cache.put(computerName, md);
                    return md;
                }
                catch (ClassCastException cce) {
                    LOGGER.log(Level.WARNING, "Failed loading maintenance definition file for {0}. Trying to read old format", this.getSafeComputerName(computerName));
                    SortedSet scheduled = (SortedSet)xmlMaintenanceFile.read();
                    md = new MaintenanceDefinitions(scheduled, new HashSet<RecurringMaintenanceWindow>());
                    this.saveMaintenanceWindows(computerName, md);
                }
            } else {
                LOGGER.log(Level.FINER, "Creating empty maintenance list for {0}", this.getSafeComputerName(computerName));
                md = new MaintenanceDefinitions(new TreeSet<MaintenanceWindow>(), new HashSet<RecurringMaintenanceWindow>());
            }
            if (Jenkins.get().getComputer(computerName) != null) {
                this.cache.put(computerName, md);
            }
        }
        return md;
    }

    @CheckForNull
    public MaintenanceWindow getMaintenanceWindow(String computerName, String id) {
        SortedSet<MaintenanceWindow> mwSet = null;
        try {
            mwSet = this.getMaintenanceWindows(computerName);
        }
        catch (IOException e) {
            return null;
        }
        Optional<MaintenanceWindow> mw = mwSet.stream().filter(w -> w.getId().equals(id)).findFirst();
        return mw.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public MaintenanceWindow getMaintenance(String computerName) {
        MaintenanceDefinitions md;
        try {
            md = this.getMaintenanceDefinitions(computerName);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read maintenance window list for {0}", this.getSafeComputerName(computerName));
            return null;
        }
        MaintenanceWindow active = null;
        MaintenanceDefinitions maintenanceDefinitions = md;
        synchronized (maintenanceDefinitions) {
            Iterator iter = md.getScheduled().iterator();
            boolean changed = false;
            try {
                while (iter.hasNext()) {
                    MaintenanceWindow m = (MaintenanceWindow)iter.next();
                    if (m.isMaintenanceScheduled() && active == null) {
                        active = m;
                        continue;
                    }
                    if (!m.isMaintenanceOver()) continue;
                    iter.remove();
                    changed = true;
                }
            }
            finally {
                if (changed) {
                    try {
                        this.saveMaintenanceWindows(computerName, md);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to save maintenance definitions for agent {0}", this.getSafeComputerName(computerName));
                    }
                }
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRecurring(String computerName) {
        MaintenanceDefinitions md;
        LOGGER.log(Level.FINER, "Checking for recurring maintenance windows for {0}", this.getSafeComputerName(computerName));
        try {
            md = this.getMaintenanceDefinitions(computerName);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read maintenance definitions for {0}", this.getSafeComputerName(computerName));
            return;
        }
        boolean added = false;
        MaintenanceDefinitions maintenanceDefinitions = md;
        synchronized (maintenanceDefinitions) {
            for (RecurringMaintenanceWindow rmw : md.getRecurring()) {
                Set<MaintenanceWindow> fmw = rmw.getFutureMaintenanceWindows();
                if (fmw.isEmpty()) continue;
                LOGGER.log(Level.FINER, "Found future maintenance windows for {0}", this.getSafeComputerName(computerName));
                md.getScheduled().addAll(fmw);
                added = true;
            }
            if (added) {
                try {
                    this.saveMaintenanceWindows(computerName, md);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to save maintenance definitions for agent {0}", this.getSafeComputerName(computerName));
                }
            }
        }
    }

    public static MaintenanceHelper getInstance() {
        return INSTANCE;
    }

    public void saveMaintenanceWindows(String computerName, MaintenanceDefinitions md) throws IOException {
        LOGGER.log(Level.FINER, "Saving maintenance window for {0}", this.getSafeComputerName(computerName));
        XmlFile xmlMaintenanceFile = this.getMaintenanceWindowsFile(computerName);
        xmlMaintenanceFile.write((Object)md);
    }

    private XmlFile getMaintenanceWindowsFile(String computerName) throws IOException {
        return new XmlFile(new File(new File(this.getNodesDirectory(), computerName), "maintenance-windows.xml"));
    }

    private File getNodesDirectory() throws IOException {
        File nodesDir = new File(Jenkins.get().getRootDir(), "nodes");
        if (!nodesDir.exists() || !nodesDir.isDirectory()) {
            throw new IOException("Nodes directory does not exist");
        }
        return nodesDir;
    }

    public void deleteAgent(String computerName) {
        this.cache.remove(computerName);
    }

    public void renameAgent(String oldName, String newName) {
        MaintenanceDefinitions md = this.cache.get(oldName);
        if (md != null) {
            LOGGER.log(Level.FINEST, "Persisting existing maintenance windows after agent rename");
            this.cache.remove(oldName);
            this.cache.put(newName, md);
            try {
                this.saveMaintenanceWindows(newName, md);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to persists agent maintenance windows after agent rename {0}", newName);
            }
        }
    }

    public void createAgent(String nodeName) {
        this.cache.put(nodeName, new MaintenanceDefinitions(new TreeSet<MaintenanceWindow>(), new HashSet<RecurringMaintenanceWindow>()));
    }

    public boolean injectRetentionStrategy(Computer c) {
        SlaveComputer computer;
        RetentionStrategy strategy;
        if (c instanceof SlaveComputer && !((strategy = (computer = (SlaveComputer)c).getRetentionStrategy()) instanceof AgentMaintenanceRetentionStrategy)) {
            AgentMaintenanceRetentionStrategy maintenanceStrategy = new AgentMaintenanceRetentionStrategy((RetentionStrategy<SlaveComputer>)strategy);
            Slave node = computer.getNode();
            if (node != null) {
                node.setRetentionStrategy((RetentionStrategy)maintenanceStrategy);
                try {
                    node.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to save Node while injecting retention strategy: ", e);
                }
                return true;
            }
        }
        return false;
    }

    public boolean removeRetentionStrategy(Computer c) {
        if (c instanceof SlaveComputer) {
            SlaveComputer computer = (SlaveComputer)c;
            String computerName = computer.getName();
            RetentionStrategy strategy = computer.getRetentionStrategy();
            if (strategy instanceof AgentMaintenanceRetentionStrategy) {
                AgentMaintenanceRetentionStrategy maintenanceStrategy = (AgentMaintenanceRetentionStrategy)strategy;
                Slave node = computer.getNode();
                if (node != null) {
                    node.setRetentionStrategy(maintenanceStrategy.getRegularRetentionStrategy());
                    try {
                        node.save();
                        this.deleteAgent(computerName);
                        XmlFile maintenanceFile = this.getMaintenanceWindowsFile(computerName);
                        if (maintenanceFile.exists()) {
                            maintenanceFile.delete();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to save node or remove file with maintenance windows while removing retention strategy: ", e);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int parseDurationString(String input) {
        int waitMinutes;
        Pattern dayRegex = Pattern.compile("(\\d{1,4})d");
        Pattern hourRegex = Pattern.compile("(\\d{1,2})h");
        Pattern minRegex = Pattern.compile("(\\d{1,2})m");
        Matcher dayMatch = dayRegex.matcher(input);
        Matcher hourMatch = hourRegex.matcher(input);
        Matcher minMatch = minRegex.matcher(input);
        boolean hourMatched = hourMatch.find();
        boolean minMatched = minMatch.find();
        boolean dayMatched = dayMatch.find();
        if (hourMatched || minMatched || dayMatched) {
            int hour = 0;
            int min = 0;
            int day = 0;
            if (dayMatched) {
                day = Integer.parseInt(dayMatch.group(1));
            }
            if (hourMatched) {
                hour = Integer.parseInt(hourMatch.group(1));
            }
            if (minMatched) {
                min = Integer.parseInt(minMatch.group(1));
            }
            return day * 60 * 24 + hour * 60 + min;
        }
        try {
            waitMinutes = Integer.parseInt(input);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return waitMinutes;
    }
}

