/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import hudson.Extension;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.slaves.AbstractCloudSlave;
import hudson.util.HttpResponses;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"agent-maintenance"})
public class MaintenanceConfiguration
extends GlobalConfiguration {
    private boolean injectRetentionStrategy;

    @DataBoundConstructor
    public MaintenanceConfiguration() {
        this.load();
    }

    public void setInjectRetentionStrategy(boolean injectRetentionStrategy) {
        this.injectRetentionStrategy = injectRetentionStrategy;
        this.save();
    }

    public boolean isInjectRetentionStrategy() {
        return this.injectRetentionStrategy;
    }

    public static MaintenanceConfiguration getInstance() {
        return (MaintenanceConfiguration)((Object)GlobalConfiguration.all().get(MaintenanceConfiguration.class));
    }

    @POST
    public HttpResponse doInject(StaplerResponse2 rsp) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        int counter = 0;
        for (Node node : Jenkins.get().getNodes()) {
            if (!(node instanceof Slave) || node instanceof AbstractCloudSlave || !MaintenanceHelper.getInstance().injectRetentionStrategy(node.toComputer())) continue;
            ++counter;
        }
        String message = "<div>Injected maintenance strategy to " + counter + " agents</div>";
        return HttpResponses.literalHtml((String)message);
    }

    @POST
    public HttpResponse doRemove(StaplerResponse2 rsp) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        int counter = 0;
        for (Node node : Jenkins.get().getNodes()) {
            if (!(node instanceof Slave) || node instanceof AbstractCloudSlave || !MaintenanceHelper.getInstance().removeRetentionStrategy(node.toComputer())) continue;
            ++counter;
        }
        String message = "<div>Removed maintenance strategy from " + counter + " agents</div>";
        return HttpResponses.literalHtml((String)message);
    }
}

