/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceOfflineCause;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.slaves.OfflineCause;
import hudson.util.FormValidation;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.security.core.Authentication;

public class MaintenanceWindow
extends AbstractDescribableImpl<MaintenanceWindow>
implements Comparable<MaintenanceWindow> {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter DATE_INPUT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-M-d H:m");
    private transient String startTime;
    private transient String endTime;
    private final String reason;
    private final boolean takeOnline;
    private final boolean keepUpWhenActive;
    private final int maxWaitMinutes;
    private final String userid;
    private String id;
    private LocalDateTime startDateTime;
    private LocalDateTime endDateTime;
    private transient boolean aborted;

    @Deprecated
    public MaintenanceWindow(String startTime, String endTime, String reason, boolean takeOnline, boolean keepUpWhenActive, int maxWaitMinutes, String userid, String id) {
        this(startTime, endTime, reason, takeOnline, keepUpWhenActive, Integer.toString(maxWaitMinutes), userid, id);
    }

    @DataBoundConstructor
    public MaintenanceWindow(String startTime, String endTime, String reason, boolean takeOnline, boolean keepUpWhenActive, String maxWaitMinutes, String userid, String id) {
        this(LocalDateTime.parse(startTime, DATE_INPUT_FORMATTER), LocalDateTime.parse(endTime, DATE_INPUT_FORMATTER), reason, takeOnline, keepUpWhenActive, maxWaitMinutes, userid, id);
    }

    public MaintenanceWindow(LocalDateTime startTime, LocalDateTime endTime, String reason, boolean takeOnline, boolean keepUpWhenActive, String maxWaitMinutes, String userid, String id) {
        this.startDateTime = startTime;
        this.endDateTime = endTime;
        this.reason = reason;
        this.takeOnline = takeOnline;
        this.maxWaitMinutes = MaintenanceHelper.parseDurationString(maxWaitMinutes);
        this.keepUpWhenActive = keepUpWhenActive;
        if (Util.fixEmptyAndTrim((String)userid) == null) {
            Authentication auth = Jenkins.getAuthentication2();
            userid = "System";
            if (auth != ACL.SYSTEM2) {
                userid = auth.getName();
            }
        }
        this.userid = userid;
        id = Util.fixEmptyAndTrim((String)id) == null ? UUID.randomUUID().toString() : MaintenanceHelper.getUuid(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getUserid() {
        return this.userid;
    }

    public boolean isKeepUpWhenActive() {
        return this.keepUpWhenActive;
    }

    public boolean buildsHaveBeenAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public int getMaxWaitMinutes() {
        return this.maxWaitMinutes;
    }

    public boolean isTakeOnline() {
        return this.takeOnline;
    }

    protected Object readResolve() {
        if (this.startTime != null) {
            this.startDateTime = LocalDateTime.parse(this.startTime, DATE_INPUT_FORMATTER);
            this.endDateTime = LocalDateTime.parse(this.endTime, DATE_INPUT_FORMATTER);
        }
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        return this;
    }

    public String getStartTime() {
        return this.startDateTime.format(DATE_FORMATTER);
    }

    public String getEndTime() {
        return this.endDateTime.format(DATE_FORMATTER);
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isMaxWaitTimeFinished() {
        if (this.maxWaitMinutes < 0) {
            return false;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime maxWaitTime = this.startDateTime.plusMinutes(this.maxWaitMinutes);
        return now.isAfter(maxWaitTime);
    }

    public boolean isMaintenanceScheduled() {
        LocalDateTime now = LocalDateTime.now();
        return now.isAfter(this.startDateTime) && now.isBefore(this.endDateTime);
    }

    public boolean isMaintenanceOver() {
        LocalDateTime now = LocalDateTime.now();
        return !now.isBefore(this.endDateTime);
    }

    public OfflineCause getOfflineCause(String computerName) {
        return new MaintenanceOfflineCause(this, computerName);
    }

    private static int compareTimes(String time1, String time2) {
        LocalDateTime startTimeCalendar = LocalDateTime.parse(time1, DATE_INPUT_FORMATTER);
        LocalDateTime endTimeCalendar = LocalDateTime.parse(time2, DATE_INPUT_FORMATTER);
        return startTimeCalendar.compareTo(endTimeCalendar);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endDateTime == null ? 0 : this.endDateTime.hashCode());
        result = 31 * result + (this.keepUpWhenActive ? 1231 : 1237);
        result = 31 * result + this.maxWaitMinutes;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.startDateTime == null ? 0 : this.startDateTime.hashCode());
        result = 31 * result + (this.takeOnline ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow)obj;
        if (this.endDateTime == null ? other.endDateTime != null : !this.endDateTime.equals(other.endDateTime)) {
            return false;
        }
        if (this.keepUpWhenActive != other.keepUpWhenActive) {
            return false;
        }
        if (this.maxWaitMinutes != other.maxWaitMinutes) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        if (this.startDateTime == null ? other.startDateTime != null : !this.startDateTime.equals(other.startDateTime)) {
            return false;
        }
        return this.takeOnline == other.takeOnline;
    }

    @Override
    public int compareTo(@NonNull MaintenanceWindow other) {
        int compare = this.startDateTime.compareTo(other.startDateTime);
        if (compare != 0) {
            return compare;
        }
        compare = this.endDateTime.compareTo(other.endDateTime);
        if (compare != 0) {
            return compare;
        }
        compare = this.reason.compareTo(other.reason);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.maxWaitMinutes, other.maxWaitMinutes);
        if (compare != 0) {
            return compare;
        }
        compare = Boolean.compare(this.keepUpWhenActive, other.keepUpWhenActive);
        if (compare != 0) {
            return compare;
        }
        compare = Boolean.compare(this.takeOnline, other.takeOnline);
        return compare;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<MaintenanceWindow> {
        @NonNull
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckStartTime(@QueryParameter String startTime, @QueryParameter(value="endTime") String endTime) {
            if (!this.isValidDate(startTime)) {
                return FormValidation.error((String)"\"%s\" is not a valid date for start time", (Object[])new Object[]{startTime});
            }
            if (!this.isValidDate(endTime)) {
                return FormValidation.error((String)"\"%s\" is not a valid date for end time", (Object[])new Object[]{endTime});
            }
            if (MaintenanceWindow.compareTimes(startTime, endTime) > 0) {
                return FormValidation.warning((String)"Start time is after end time.");
            }
            return FormValidation.ok();
        }

        private boolean isValidDate(String date) {
            try {
                LocalDateTime.parse(date, DATE_INPUT_FORMATTER);
            }
            catch (DateTimeParseException e) {
                return false;
            }
            return true;
        }
    }
}

