/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceInterruption;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceOfflineCause;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceWindow;
import com.sap.prd.jenkins.plugins.agent_maintenance.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Slave;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class AgentMaintenanceRetentionStrategy
extends RetentionStrategy<SlaveComputer> {
    private static final Logger LOGGER = Logger.getLogger(AgentMaintenanceRetentionStrategy.class.getName());
    private RetentionStrategy<SlaveComputer> regularRetentionStrategy;

    @DataBoundConstructor
    public AgentMaintenanceRetentionStrategy(RetentionStrategy<SlaveComputer> regularRetentionStrategy) {
        this.regularRetentionStrategy = regularRetentionStrategy;
    }

    public RetentionStrategy<?> getRegularRetentionStrategy() {
        return this.regularRetentionStrategy;
    }

    public void setRegularRetentionStrategy(RetentionStrategy<SlaveComputer> regularRetentionStrategy) {
        this.regularRetentionStrategy = regularRetentionStrategy;
    }

    public boolean isAcceptingTasks(SlaveComputer c) {
        MaintenanceWindow maintenance = MaintenanceHelper.getInstance().getMaintenance(c.getName());
        if (maintenance != null) {
            return false;
        }
        return this.regularRetentionStrategy.isAcceptingTasks((Computer)c);
    }

    public boolean isManualLaunchAllowed(SlaveComputer c) {
        MaintenanceWindow maintenance = MaintenanceHelper.getInstance().getMaintenance(c.getName());
        if (maintenance != null) {
            return false;
        }
        return this.regularRetentionStrategy.isManualLaunchAllowed((Computer)c);
    }

    @GuardedBy(value="hudson.model.Queue.lock")
    public synchronized long check(final SlaveComputer c) {
        final MaintenanceWindow maintenance = MaintenanceHelper.getInstance().getMaintenance(c.getName());
        MaintenanceHelper.getInstance().checkRecurring(c.getName());
        LOGGER.log(Level.FINER, "Checking for Maintenance Window for agent {0}. online = {1}, idle = {2}", new Object[]{c.getName(), c.isOnline(), c.isIdle()});
        if (maintenance != null) {
            LOGGER.log(Level.FINE, "Active Maintenance Window found for agent {0}: startTime = {1}, endTime = {2}", new Object[]{c.getName(), maintenance.getStartTime(), maintenance.getEndTime()});
            if (c.isOnline()) {
                if (maintenance.isKeepUpWhenActive()) {
                    if (!maintenance.isMaxWaitTimeFinished()) {
                        if (c.isIdle()) {
                            Queue.withLock((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    LOGGER.log(Level.INFO, "Disconnecting agent {0} as it was idle when maintenance window started.", new Object[]{c.getName()});
                                    c.disconnect(maintenance.getOfflineCause(c.getName()));
                                }
                            });
                        }
                    } else if (maintenance.buildsHaveBeenAborted()) {
                        LOGGER.log(Level.INFO, "Disconnecting agent {0} as it has finished its scheduled uptime and max waiting time for builds to finish is over", new Object[]{c.getName()});
                        c.disconnect(maintenance.getOfflineCause(c.getName()));
                    } else {
                        LOGGER.log(Level.INFO, "Aborting running builds on agent {0} as it has finished its scheduled uptime and max waiting time for builds to finish is over", new Object[]{c.getName()});
                        for (Executor e : c.getExecutors()) {
                            if (!e.isBusy()) continue;
                            e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new MaintenanceInterruption()});
                        }
                        maintenance.setAborted(true);
                    }
                } else if (maintenance.buildsHaveBeenAborted()) {
                    LOGGER.log(Level.INFO, "Disconnecting agent {0} as it has finished its scheduled uptime", new Object[]{c.getName()});
                    c.disconnect(maintenance.getOfflineCause(c.getName()));
                } else {
                    LOGGER.log(Level.INFO, "Aborting running builds on agent {0} as it has finished its scheduled uptime", new Object[]{c.getName()});
                    for (Executor e : c.getExecutors()) {
                        if (!e.isBusy()) continue;
                        e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new MaintenanceInterruption()});
                    }
                    maintenance.setAborted(true);
                }
            }
        } else {
            MaintenanceOfflineCause moc;
            OfflineCause oc;
            if (c.isOffline() && (oc = c.getOfflineCause()) instanceof MaintenanceOfflineCause && !(moc = (MaintenanceOfflineCause)oc).isTakeOnline()) {
                LOGGER.log(Level.INFO, "Computer should not be taken online automatically: {0}", c.getName());
                return 5L;
            }
            return this.regularRetentionStrategy.check((Computer)c);
        }
        return 1L;
    }

    @Extension
    @Symbol(value={"agent-maintenance"})
    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        @NonNull
        public String getDisplayName() {
            return Messages.AgentMaintenanceRetentionStrategy_displayName();
        }

        public final List<Descriptor<RetentionStrategy<?>>> retentionStrategyDescriptors(@CheckForNull Slave it) {
            List descriptors = it == null ? DescriptorVisibilityFilter.applyType(Slave.class, (Iterable)RetentionStrategy.all()) : DescriptorVisibilityFilter.apply((Object)it, (Iterable)RetentionStrategy.all());
            descriptors.remove((Object)this);
            return descriptors;
        }
    }
}

