/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.adoptopenjdk;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.DownloadService;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.tools.ZipExtractionInstaller;
import io.jenkins.plugins.adoptopenjdk.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.io.input.CountingInputStream;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class AdoptOpenJDKInstaller
extends ToolInstaller {
    private static boolean DISABLE_CACHE = Boolean.getBoolean(AdoptOpenJDKInstaller.class.getName() + ".cache.disable");
    public final String id;

    @DataBoundConstructor
    public AdoptOpenJDKInstaller(String id) {
        super(null);
        this.id = id;
    }

    @NonNull
    private static AdoptOpenJDKFamilyList getAdoptOpenJDKFamilyList() throws IOException {
        AdoptOpenJDKList list = (AdoptOpenJDKList)((Object)AdoptOpenJDKList.all().get(AdoptOpenJDKList.class));
        if (list == null) {
            throw new IOException(Messages.AdoptOpenJDKInstaller_getAdoptOpenJDKFamilyList_NoDownloadable());
        }
        return list.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expected;
        block27: {
            expected = this.preferredLocation(tool, node);
            try {
                CPU c;
                FilePath marker = expected.child(".installedByJenkins");
                if (marker.exists() && marker.readToString().equals(this.id)) {
                    return expected;
                }
                expected.deleteRecursive();
                expected.mkdirs();
                AdoptOpenJDKFamilyList jdkFamilyList = AdoptOpenJDKInstaller.getAdoptOpenJDKFamilyList();
                if (jdkFamilyList.isEmpty()) {
                    throw new IOException(Messages.AdoptOpenJDKInstaller_performInstallation_emptyJdkFamilyList());
                }
                AdoptOpenJDKRelease release = jdkFamilyList.getRelease(this.id);
                if (release == null) {
                    throw new IOException(Messages.AdoptOpenJDKInstaller_performInstallation_releaseNotFound(this.id));
                }
                Platform p = Platform.of(node);
                AdoptOpenJDKFile binary = release.getBinary(p, c = CPU.of(node));
                if (binary == null) {
                    throw new IOException(Messages.AdoptOpenJDKInstaller_performInstallation_binaryNotFound(this.id, p.name(), c.name()));
                }
                File cache = this.getLocalCacheFile(p, c);
                if (!DISABLE_CACHE && cache.exists()) {
                    try (InputStream in = cache.toURI().toURL().openStream();){
                        CountingInputStream cis = new CountingInputStream(in);
                        try {
                            log.getLogger().println(Messages.AdoptOpenJDKInstaller_performInstallation_fromCache(cache, expected, node.getDisplayName()));
                            FilePath parent = expected.getParent();
                            if (parent != null) {
                                parent.unzipFrom((InputStream)cis);
                                break block27;
                            }
                            throw new NullPointerException("Parent directory of " + String.valueOf(expected) + " is null");
                        }
                        catch (IOException e) {
                            throw new IOException(Messages.AdoptOpenJDKInstaller_performInstallation_failedToUnpack(cache.toURI().toURL(), cis.getByteCount()), e);
                        }
                    }
                }
                String url = binary.binary_link;
                ZipExtractionInstaller zipExtractionInstaller = new ZipExtractionInstaller(null, url, null);
                FilePath installation = zipExtractionInstaller.performInstallation(tool, node, log);
                installation.child(".timestamp").delete();
                FilePath base = this.findPullUpDirectory(installation, p);
                if (base != null && base != expected) {
                    base.moveAllChildrenTo(expected);
                }
                marker.write(this.id, null);
                if (DISABLE_CACHE) break block27;
                Path tmp = new File(cache.getPath() + ".tmp").toPath();
                try {
                    Path tmpParent = tmp.getParent();
                    if (tmpParent != null) {
                        Files.createDirectories(tmpParent, new FileAttribute[0]);
                    }
                    try (OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
                        expected.zip(out);
                    }
                    Files.move(tmp, cache.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    Files.deleteIfExists(tmp);
                }
            }
            catch (DetectionFailedException e) {
                log.getLogger().println(Messages.AdoptOpenJDKInstaller_performInstallation_JdkSkipped(e.getMessage()));
            }
        }
        return expected;
    }

    private File getLocalCacheFile(Platform platform, CPU cpu) {
        return new File(Jenkins.get().getRootDir(), "caches/adoptopenjdk/" + String.valueOf((Object)platform) + "/" + String.valueOf((Object)cpu) + "/" + this.id + ".zip");
    }

    protected FilePath findPullUpDirectory(FilePath root, Platform platform) throws IOException, InterruptedException {
        FilePath contents;
        List children = root.listDirectories();
        if (children.size() != 1) {
            return null;
        }
        if (platform == Platform.MACOS && (contents = ((FilePath)children.get(0)).child("Contents/Home")).exists() && contents.isDirectory()) {
            return contents;
        }
        return (FilePath)children.get(0);
    }

    @Extension
    @Symbol(value={"adoptOpenJdk"})
    public static final class AdoptOpenJDKList
    extends DownloadService.Downloadable {
        public AdoptOpenJDKList() {
            super(AdoptOpenJDKInstaller.class);
        }

        public AdoptOpenJDKFamilyList toList() throws IOException {
            JSONObject d = this.getData();
            if (d == null) {
                return new AdoptOpenJDKFamilyList();
            }
            return (AdoptOpenJDKFamilyList)JSONObject.toBean((JSONObject)d, AdoptOpenJDKFamilyList.class);
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field initialized during deserialization from JSON object")
    public static final class AdoptOpenJDKFamilyList {
        public AdoptOpenJDKFamily[] data = new AdoptOpenJDKFamily[0];
        public int version;

        public boolean isEmpty() {
            for (AdoptOpenJDKFamily f : this.data) {
                if (f.releases.length <= 0) continue;
                return false;
            }
            return true;
        }

        public AdoptOpenJDKRelease getRelease(String productCode) {
            for (AdoptOpenJDKFamily f : this.data) {
                for (AdoptOpenJDKRelease r : f.releases) {
                    if (!r.matchesId(productCode)) continue;
                    return r;
                }
            }
            return null;
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field initialized during deserialization from JSON object")
    public static final class AdoptOpenJDKRelease {
        public AdoptOpenJDKFile[] binaries;
        public String release_name;
        public String openjdk_impl;

        public boolean matchesId(String rhs) {
            return rhs != null && rhs.equals(this.release_name);
        }

        public AdoptOpenJDKFile getBinary(Platform platform, CPU cpu) throws IOException {
            block8: for (AdoptOpenJDKFile f : this.binaries) {
                if (!platform.getId().equals(f.os) || !this.openjdk_impl.equals(f.openjdk_impl)) continue;
                switch (cpu.ordinal()) {
                    case 0: {
                        if (!f.architecture.equals("x32")) continue block8;
                        return f;
                    }
                    case 1: {
                        if (!f.architecture.equals("x64")) continue block8;
                        return f;
                    }
                    case 2: {
                        if (!f.architecture.equals("sparcv9")) continue block8;
                        return f;
                    }
                    case 4: {
                        if (!f.architecture.equals("ppc64") && !f.architecture.equals("ppc64le")) continue block8;
                        return f;
                    }
                    case 3: {
                        if (!f.architecture.equals("s390x")) continue block8;
                        return f;
                    }
                    case 5: {
                        if (!f.architecture.equals("arm") && !f.architecture.equals("aarch64")) continue block8;
                        return f;
                    }
                    default: {
                        throw new IOException(Messages.AdoptOpenJDKInstaller_AdoptOpenJDKRelease_usupportedCpu(cpu.name()));
                    }
                }
            }
            return null;
        }
    }

    public static enum Platform {
        LINUX("linux"),
        ALPINE_LINUX("alpine-linux"),
        WINDOWS("windows"),
        MACOS("mac"),
        SOLARIS("solaris"),
        AIX("aix");

        private final String id;
        static String osReleaseLocation;

        private Platform(String id) {
            this.id = id;
        }

        public static Platform of(Node n) throws IOException, InterruptedException, DetectionFailedException {
            VirtualChannel channel = n.getChannel();
            if (channel == null) {
                throw new IOException(Messages.AdoptOpenJDKInstaller_Platform_nullChannel(n.getDisplayName()));
            }
            return (Platform)((Object)channel.call((Callable)new GetCurrentPlatform()));
        }

        public static Platform current() throws DetectionFailedException {
            String arch = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            if (arch.contains("linux")) {
                return Platform.isAlpineLinux() ? ALPINE_LINUX : LINUX;
            }
            if (arch.contains("windows")) {
                return WINDOWS;
            }
            if (arch.contains("sun") || arch.contains("solaris")) {
                return SOLARIS;
            }
            if (arch.contains("mac")) {
                return MACOS;
            }
            if (arch.contains("aix")) {
                return AIX;
            }
            throw new DetectionFailedException(Messages.AdoptOpenJDKInstaller_Platform_unknownPlatform(arch));
        }

        static boolean isAlpineLinux() {
            boolean bl;
            block8: {
                File osRelease = new File(osReleaseLocation);
                Stream<String> lines = Files.lines(osRelease.toPath(), Charset.defaultCharset());
                try {
                    bl = lines.anyMatch("ID=alpine"::equalsIgnoreCase);
                    if (lines == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (lines != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        return false;
                    }
                }
                lines.close();
            }
            return bl;
        }

        public String getId() {
            return this.id;
        }

        static {
            osReleaseLocation = "/etc/os-release";
        }

        static class GetCurrentPlatform
        extends MasterToSlaveCallable<Platform, DetectionFailedException> {
            private static final long serialVersionUID = 1L;

            GetCurrentPlatform() {
            }

            public Platform call() throws DetectionFailedException {
                return Platform.current();
            }
        }
    }

    public static enum CPU {
        i386,
        amd64,
        Sparc,
        s390x,
        ppc64,
        arm;


        public static CPU of(Node n) throws IOException, InterruptedException, DetectionFailedException {
            VirtualChannel channel = n.getChannel();
            if (channel == null) {
                throw new IOException(Messages.AdoptOpenJDKInstaller_CPU_nullChannel(n.getDisplayName()));
            }
            return (CPU)((Object)channel.call((Callable)new GetCurrentCPU()));
        }

        public static CPU current() throws DetectionFailedException {
            String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            if (arch.contains("sparc")) {
                return Sparc;
            }
            if (arch.contains("amd64") || arch.contains("86_64")) {
                return amd64;
            }
            if (arch.contains("86")) {
                return i386;
            }
            if (arch.contains("s390x")) {
                return s390x;
            }
            if (arch.contains("ppc64")) {
                return ppc64;
            }
            if (arch.contains("arm") || arch.contains("aarch64")) {
                return arm;
            }
            throw new DetectionFailedException(Messages.AdoptOpenJDKInstaller_CPU_unknownCpu(arch));
        }

        static class GetCurrentCPU
        extends MasterToSlaveCallable<CPU, DetectionFailedException> {
            private static final long serialVersionUID = 1L;

            GetCurrentCPU() {
            }

            public CPU call() throws DetectionFailedException {
                return CPU.current();
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field initialized during deserialization from JSON object")
    public static final class AdoptOpenJDKFile {
        public String architecture;
        public String os;
        public String openjdk_impl;
        public String binary_link;
    }

    private static final class DetectionFailedException
    extends Exception {
        private DetectionFailedException(String message) {
            super(message);
        }
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field initialized during deserialization from JSON object")
    public static final class AdoptOpenJDKFamily {
        public String name;
        public AdoptOpenJDKRelease[] releases;
    }

    @Extension
    @Symbol(value={"adoptOpenJdkInstaller"})
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<AdoptOpenJDKInstaller> {
        @NonNull
        public String getDisplayName() {
            return Messages.AdoptOpenJDKInstaller_DescriptorImpl_DisplayName();
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == JDK.class;
        }

        public List<AdoptOpenJDKFamily> getInstallableJDKs() throws IOException {
            return Arrays.asList(AdoptOpenJDKInstaller.getAdoptOpenJDKFamilyList().data);
        }
    }
}

