// CHECKSTYLE:OFF

package io.jenkins.plugins.adoptopenjdk;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code AdoptOpenJDKInstaller.Platform.unknownPlatform}: {@code
     * Unknown Platform name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown Platform name: {0}}
     */
    public static String AdoptOpenJDKInstaller_Platform_unknownPlatform(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.Platform.unknownPlatform", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.Platform.unknownPlatform}: {@code
     * Unknown Platform name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown Platform name: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_Platform_unknownPlatform(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.Platform.unknownPlatform", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.DescriptorImpl.DisplayName}: {@code
     * Install from adoptium.net}.
     * 
     * @return
     *     {@code Install from adoptium.net}
     */
    public static String AdoptOpenJDKInstaller_DescriptorImpl_DisplayName() {
        return holder.format("AdoptOpenJDKInstaller.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.DescriptorImpl.DisplayName}: {@code
     * Install from adoptium.net}.
     * 
     * @return
     *     {@code Install from adoptium.net}
     */
    public static Localizable _AdoptOpenJDKInstaller_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "AdoptOpenJDKInstaller.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.CPU.unknownCpu}: {@code Unknown CPU
     * architecture: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown CPU architecture: {0}}
     */
    public static String AdoptOpenJDKInstaller_CPU_unknownCpu(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.CPU.unknownCpu", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.CPU.unknownCpu}: {@code Unknown CPU
     * architecture: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown CPU architecture: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_CPU_unknownCpu(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.CPU.unknownCpu", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.CPU.nullChannel}: {@code Channel is
     * null, cannot determine CPU of: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Channel is null, cannot determine CPU of: {0}}
     */
    public static String AdoptOpenJDKInstaller_CPU_nullChannel(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.CPU.nullChannel", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.CPU.nullChannel}: {@code Channel is
     * null, cannot determine CPU of: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Channel is null, cannot determine CPU of: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_CPU_nullChannel(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.CPU.nullChannel", arg0);
    }

    /**
     * Key {@code
     * AdoptOpenJDKInstaller.getAdoptOpenJDKFamilyList.NoDownloadable}:
     * {@code AdoptOpenJDKList is not registered as a Downloadable}.
     * 
     * @return
     *     {@code AdoptOpenJDKList is not registered as a Downloadable}
     */
    public static String AdoptOpenJDKInstaller_getAdoptOpenJDKFamilyList_NoDownloadable() {
        return holder.format("AdoptOpenJDKInstaller.getAdoptOpenJDKFamilyList.NoDownloadable");
    }

    /**
     * Key {@code
     * AdoptOpenJDKInstaller.getAdoptOpenJDKFamilyList.NoDownloadable}:
     * {@code AdoptOpenJDKList is not registered as a Downloadable}.
     * 
     * @return
     *     {@code AdoptOpenJDKList is not registered as a Downloadable}
     */
    public static Localizable _AdoptOpenJDKInstaller_getAdoptOpenJDKFamilyList_NoDownloadable() {
        return new Localizable(holder, "AdoptOpenJDKInstaller.getAdoptOpenJDKFamilyList.NoDownloadable");
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.fromCache}:
     * {@code Installing Eclipse Temurin from {0} to {1} on {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing Eclipse Temurin from {0} to {1} on {2}}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_fromCache(Object arg0, Object arg1, Object arg2) {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.fromCache", arg0, arg1, arg2);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.fromCache}:
     * {@code Installing Eclipse Temurin from {0} to {1} on {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing Eclipse Temurin from {0} to {1} on {2}}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_fromCache(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.fromCache", arg0, arg1, arg2);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.path}: {@code
     * Installing Eclipse Temurin to {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing Eclipse Temurin to {0}}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_path(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.path", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.path}: {@code
     * Installing Eclipse Temurin to {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing Eclipse Temurin to {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_path(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.path", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.Platform.nullChannel}: {@code Channel
     * is null, cannot determine Platform of: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Channel is null, cannot determine Platform of: {0}}
     */
    public static String AdoptOpenJDKInstaller_Platform_nullChannel(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.Platform.nullChannel", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.Platform.nullChannel}: {@code Channel
     * is null, cannot determine Platform of: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Channel is null, cannot determine Platform of: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_Platform_nullChannel(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.Platform.nullChannel", arg0);
    }

    /**
     * Key {@code
     * AdoptOpenJDKInstaller.performInstallation.emptyJdkFamilyList}: {@code
     * Unable to download release list}.
     * 
     * @return
     *     {@code Unable to download release list}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_emptyJdkFamilyList() {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.emptyJdkFamilyList");
    }

    /**
     * Key {@code
     * AdoptOpenJDKInstaller.performInstallation.emptyJdkFamilyList}: {@code
     * Unable to download release list}.
     * 
     * @return
     *     {@code Unable to download release list}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_emptyJdkFamilyList() {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.emptyJdkFamilyList");
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.releaseNotFound}:
     * {@code Unable to locate release: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to locate release: {0}}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_releaseNotFound(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.releaseNotFound", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.releaseNotFound}:
     * {@code Unable to locate release: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to locate release: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_releaseNotFound(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.releaseNotFound", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.binaryNotFound}:
     * {@code Unable to locate binary. A release might not exist for the
     * selected combination. ID: {0}, Platform: {1}, CPU: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to locate binary. A release might not exist for the
     *     selected combination. ID: {0}, Platform: {1}, CPU: {2}}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_binaryNotFound(Object arg0, Object arg1, Object arg2) {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.binaryNotFound", arg0, arg1, arg2);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.binaryNotFound}:
     * {@code Unable to locate binary. A release might not exist for the
     * selected combination. ID: {0}, Platform: {1}, CPU: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to locate binary. A release might not exist for the
     *     selected combination. ID: {0}, Platform: {1}, CPU: {2}}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_binaryNotFound(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.binaryNotFound", arg0, arg1, arg2);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.failedToUnpack}:
     * {@code Failed to unpack {0} ({1} bytes read)}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to unpack {0} ({1} bytes read)}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_failedToUnpack(Object arg0, Object arg1) {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.failedToUnpack", arg0, arg1);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.failedToUnpack}:
     * {@code Failed to unpack {0} ({1} bytes read)}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to unpack {0} ({1} bytes read)}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_failedToUnpack(Object arg0, Object arg1) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.failedToUnpack", arg0, arg1);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.JdkSkipped}:
     * {@code Eclipse Temurin installation skipped: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Eclipse Temurin installation skipped: {0}}
     */
    public static String AdoptOpenJDKInstaller_performInstallation_JdkSkipped(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.performInstallation.JdkSkipped", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.performInstallation.JdkSkipped}:
     * {@code Eclipse Temurin installation skipped: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Eclipse Temurin installation skipped: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_performInstallation_JdkSkipped(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.performInstallation.JdkSkipped", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.AdoptOpenJDKRelease.usupportedCpu}:
     * {@code Unsupported CPU architecture: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unsupported CPU architecture: {0}}
     */
    public static String AdoptOpenJDKInstaller_AdoptOpenJDKRelease_usupportedCpu(Object arg0) {
        return holder.format("AdoptOpenJDKInstaller.AdoptOpenJDKRelease.usupportedCpu", arg0);
    }

    /**
     * Key {@code AdoptOpenJDKInstaller.AdoptOpenJDKRelease.usupportedCpu}:
     * {@code Unsupported CPU architecture: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unsupported CPU architecture: {0}}
     */
    public static Localizable _AdoptOpenJDKInstaller_AdoptOpenJDKRelease_usupportedCpu(Object arg0) {
        return new Localizable(holder, "AdoptOpenJDKInstaller.AdoptOpenJDKRelease.usupportedCpu", arg0);
    }

}
